VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.1#0"; "COMCTL32.OCX"
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Form1"
   ClientHeight    =   3975
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7140
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3975
   ScaleWidth      =   7140
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   375
      Left            =   6120
      TabIndex        =   6
      Top             =   3120
      Width           =   975
   End
   Begin VB.CommandButton cmdAdd 
      Caption         =   "&Add"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   6120
      TabIndex        =   5
      Top             =   960
      Width           =   975
   End
   Begin VB.CommandButton cmdDelete 
      Caption         =   "&Delete"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   6120
      TabIndex        =   4
      Top             =   1440
      Width           =   975
   End
   Begin VB.CommandButton cmdServer 
      Caption         =   "&Server"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   6120
      TabIndex        =   3
      Top             =   480
      Width           =   975
   End
   Begin ComctlLib.ListView lvJobs 
      Height          =   3015
      Left            =   120
      TabIndex        =   1
      Top             =   480
      Width           =   5895
      _ExtentX        =   10398
      _ExtentY        =   5318
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   327680
      Icons           =   "imgLvJobsLarge"
      SmallIcons      =   "imgLvJobsSmall"
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      NumItems        =   0
   End
   Begin ComctlLib.StatusBar sbMain 
      Align           =   2  'Align Bottom
      Height          =   255
      Left            =   0
      TabIndex        =   0
      Top             =   3720
      Width           =   7140
      _ExtentX        =   12594
      _ExtentY        =   450
      SimpleText      =   ""
      _Version        =   327680
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   3
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   1
            Object.Width           =   7408
            TextSave        =   ""
            Key             =   "Status"
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel2 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Style           =   6
            TextSave        =   "29/09/98"
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel3 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Style           =   5
            TextSave        =   "12:24"
            Object.Tag             =   ""
         EndProperty
      EndProperty
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ComctlLib.ImageList imgLvJobsLarge 
      Left            =   6120
      Top             =   1920
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   32
      ImageHeight     =   32
      MaskColor       =   12632256
      _Version        =   327680
      BeginProperty Images {0713E8C2-850A-101B-AFC0-4210102A8DA7} 
         NumListImages   =   1
         BeginProperty ListImage1 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "frmMain.frx":0442
            Key             =   "Job"
         EndProperty
      EndProperty
   End
   Begin ComctlLib.ImageList imgLvJobsSmall 
      Left            =   6120
      Top             =   2520
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      _Version        =   327680
      BeginProperty Images {0713E8C2-850A-101B-AFC0-4210102A8DA7} 
         NumListImages   =   1
         BeginProperty ListImage1 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "frmMain.frx":075C
            Key             =   "Job"
         EndProperty
      EndProperty
   End
   Begin VB.Label lblServer 
      Caption         =   "Label1"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   2
      Top             =   120
      Width           =   2415
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

' ++
' See basMain for explanation comments
' --

Option Explicit

Private Sub cmdAdd_Click()

Dim lReturn As String

'
' Show the 'Add' form and refresh lvJobs
'

    frmAdd.Show 1
    ClearLV
    lReturn = EnumJobs(sComputerName)
    
End Sub

Private Sub cmdDelete_Click()

Dim lIndex As Long
Dim lReturn As Long
Dim lMin As Long
Dim lMax As Long
    
'
' Delete the currently selected item
'

    On Error GoTo Nothing_Selected
    
    lIndex = Me.lvJobs.SelectedItem.Index
    lMin = Me.lvJobs.ListItems(lIndex)
    lMax = lMin
    
'
' Confirm that we really do want to delete this job
'

    If MsgBox( _
        "Delete Job " & Str$(lMin), _
        vbYesNo + vbQuestion) <> vbYes Then
        Exit Sub
    End If
    
    Me.MousePointer = vbHourglass
    Me.sbMain.Panels("Status").Text = _
        "Deleting Job " & Str$(lMin)
    DoEvents
    
'
' Delete the job and refresh lvJobs
'

    lReturn = DeleteJob(sComputerName, _
        lMin, _
        lMax)
        
    ClearLV
    lReturn = EnumJobs(sComputerName)
    Me.sbMain.Panels("Status").Text = "Ready"
    Me.MousePointer = vbNormal
    DoEvents
    
Nothing_Selected:

    On Error GoTo 0
    
End Sub

Private Sub cmdExit_Click()

    End
    
End Sub

Private Sub cmdServer_Click()

Dim lReturn As Long
    
'
' Show the 'Browse' form to select another server
'

    Me.MousePointer = vbHourglass
    ClearLV
    Me.sbMain.Panels("Status").Text = "Selecting Server"
    DoEvents
    frmBrowse.Show 1

'
' Get the Service info for the Schedule service
'

    Me.sbMain.Panels("Status").Text = "Checking Schedule Service status..."
    DoEvents
    
    If Not GetScheduleInfo(sComputerName) Then
        Screen.MousePointer = vbNormal
        End
    End If
    
    lReturn = EnumJobs(sComputerName)
    
    Screen.MousePointer = vbNormal
    Me.sbMain.Panels("Status").Text = "Ready"
    Me.lblServer.Caption = "Scheduled tasks for " & sComputerName & ":"
    Me.lvJobs.Refresh
    Me.MousePointer = vbNormal
    
    
End Sub

Private Sub Form_Load()

Dim lReturn As Long
Dim clsNet As clsNetAPI

    Me.Caption = "Windows Task Scheduler"
    
'
' Set up lvMain to allow whole line select
'

   Call SendMessageLong(Me.lvJobs.hwnd, _
                        LVM_SETEXTENDEDLISTVIEWSTYLE, _
                        LVS_EX_FULLROWSELECT, True)

'
' Initialize class module
'

    Set clsNet = New clsNetAPI
    
    Me.MousePointer = vbHourglass
    
'
' Get local computer name and domain name
'

    sComputerName = clsNet.GetLocalComputerName
    sDomain = clsNet.GetDomainName
    
    If sComputerName = "" Then
        Screen.MousePointer = vbNormal
        MsgBox "Cannot determine computer name, program will exit", vbOKCancel + vbCritical
        End
    End If
    
    Me.lblServer.Caption = "Scheduled tasks for " & sComputerName & ":"

'
' Set up lvJobs with relevant colums (must be report view)
'

    Me.lvJobs.ColumnHeaders. _
        Add , , "Job Id", (Me.lvJobs.Width * 1) / 12
    Me.lvJobs.ColumnHeaders. _
        Add , , "Task", (Me.lvJobs.Width * 4) / 12
    Me.lvJobs.ColumnHeaders. _
        Add , , "Day", (Me.lvJobs.Width * 4) / 12
    Me.lvJobs.ColumnHeaders. _
        Add , , "Time", (Me.lvJobs.Width * 2) / 12
    ' Set View property to Report.
    Me.lvJobs.View = lvwReport

    Me.Move (Screen.Width - Me.Width) \ 2, (Screen.Height - Me.Height) \ 2
    Me.Show
    DoEvents
    
'
' Get the Service info for the Schedule service
'

    Me.sbMain.Panels("Status").Text = "Checking Schedule Service status..."
    DoEvents
    
'
' Check that the schedule service is running
'

    If Not GetScheduleInfo(sComputerName) Then
        Me.MousePointer = vbNormal
        End
    End If

    Set clsNet = Nothing
    Me.cmdDelete.Enabled = False
    
'
' Enumerate scheduled tasks
'

    lReturn = EnumJobs(sComputerName)
    
    Me.MousePointer = vbNormal
    
    Me.sbMain.Panels("Status").Text = "Ready"
    
End Sub

Private Sub lvJobs_Click()
    
    Me.cmdDelete.Enabled = True
    
        
End Sub

Private Sub lvJobs_DblClick()

Dim lIndex As Long
Dim lJob As Long
Dim lReturn As Long

    lIndex = Me.lvJobs.SelectedItem.Index
    lJob = Val(Me.lvJobs.ListItems(lIndex).Text)
    lReturn = GetJobInfo(sComputerName, lJob)
    

End Sub

' ++
' Routine:  ClearLV
' Action:   Just clears everything from the list view control
' --

Sub ClearLV()

Dim lCount As Long
Dim lTotal As Long

    lTotal = Me.lvJobs.ListItems.Count
    If lTotal = 0 Then Exit Sub
    lCount = 1
    Do
        
        Me.lvJobs.ListItems.Remove 1
        lCount = lCount + 1
    
    Loop Until lCount > lTotal

End Sub

