VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsNetAPI"
Attribute VB_GlobalNameSpace = True
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False

'
' Module:   basNETAPI
' Created:  18th June 1998, by ASH
' Reason:   Hold Net* functions
'

'
' Constants
'

Private Const UNLEN = 256
Private Const PWLEN = 256
Private Const LM_UNLEN = 20
Private Const LM_PWLEN = 14

Private Const USER_PRIV_USER = 1

Private Const TIMEQ_FOREVER = -1
Private Const USER_MAX_STORAGE_UNLIMITED = -1

Private Const FORMAT_MESSAGE_FROM_HMODULE = &H800
Private Const FORMAT_MESSAGE_FROM_STRING = &H400
Private Const FORMAT_MESSAGE_FROM_SYSTEM = &H1000
Private Const FORMAT_MESSAGE_IGNORE_INSERTS = &H200
Private Const FORMAT_MESSAGE_MAX_WIDTH_MASK = &HFF
Private Const LANG_ENGLISH = &H9
Private Const SUBLANG_DEFAULT = &H1
Private Const SUBLANG_ENGLISH_UK = &H2
Private Const FORMAT_MESSAGE_ALLOCATE_BUFFER = &H100

Private Const UF_SCRIPT = &H1
Private Const UF_ACCOUNTDISABLE = &H2
Private Const UF_HOMEDIR_REQUIRED = &H8
Private Const UF_LOCKOUT = &H10
Private Const UF_PASSWD_NOTREQD = &H20
Private Const UF_PASSWD_CANT_CHANGE = &H40
Private Const UF_NORMAL_ACCOUNT = &H200

Private Const LOCKED_BIT = "1,3,5"
Private Const DISABLED_BIT = "2,3,A"
Private Const PDC_BIT = "8,9,A,B,F"
Private Const BDC_BIT = "1,3,5,7,9,D,F"
    
Private Const FILTER_NORMAL_ACCOUNT = &H2

Private Const WKSTA_LEVEL_100 = 100
Private Const SERVER_LEVEL_101 = 101
Private Const USER_LEVEL_2 = 2

Private Const SV_TYPE_WORKSTATION = &H1
Private Const SV_TYPE_SERVER = &H2
Private Const SV_TYPE_SQLSERVER = &H4
Private Const SV_TYPE_DOMAIN_CTRL = &H8
Private Const SV_TYPE_DOMAIN_BACKUP = &H10
Private Const SV_TYPE_TIMESOURCE = &H20
Private Const SV_TYPE_AFP = &H40
Private Const SV_TYPE_NOVELL = &H80
Private Const SV_TYPE_NT = &H8000
Private Const SV_TYPE_ALL = &HFFFFFFFF



'
' Type declarations
'

Private Type WKSTA_INFO_100
    dw_platform_id As Long
    ptr_computername As Long
    ptr_langroup As Long
    dw_ver_major As Long
    dw_ver_minor As Long
End Type

Private Type SERVER_INFO_101
    dw_platform_id As Long
    ptr_name As Long
    dw_ver_major As Long
    dw_ver_minor As Long
    dw_type As Long
    ptr_comment As Long
End Type

Private Type MungeLong
    x As Long
    Dummy As Integer
End Type

Private Type MungeInt
    xLo As Integer
    xHi As Integer
    Dummy As Integer
End Type

Private Type TUser0
    ptrName As Long
End Type

Private Type TUser1
    ptrName As Long
    ptrPassword As Long
    dwPasswordAge As Long
    dwPriv As Long
    ptrHomeDir As Long
    ptrComment As Long
    dwFlags As Long
    ptrScriptPath As Long
End Type

Private Type TUser20
    usri20_name As Long
    usri20_Full_name As Long
    usri20_Comment As Long
    usri20_flags As Long
    usri20_user_id As Long
End Type

Private Type GROUP_INFO_1
    grpi1_name As Long
    grpi1_comment As Long
End Type

Private Type LOCAL_GROUP_INFO_1
    lgrpi1_name As Long
    lgrpi1_comment As Long
End Type

Private Type USER_INFO_2
    ptr_name As Long
    ptr_password As Long
    dw_password_age As Long
    dw_priv As Long
    ptr_homedir As Long
    ptr_comment As Long
    dw_Flags As Long
    ptr_script_path As Long
    dw_auth_flags As Long
    ptr_full_name As Long
    ptr_usr_comment As Long
    ptr_parms As Long
    ptr_workstations As Long
    dw_last_logon As Long
    dw_last_logoff As Long
    dw_account_expires As Long
    dw_max_storage As Long
    dw_units_per_week As Long
    dw_logon_hours As Long
    dw_bad_password_count As Long
    dw_num_logons As Long
    ptr_logon_server As Long
    dw_country_code As Long
    dw_code_page As Long
End Type


'
' Functions
'

Private Declare Sub RtlMoveMemory _
    Lib "Kernel32" ( _
    dest As Any, _
    Vsrc As Any, _
    ByVal lSize&)

Private Declare Function NetServerEnum _
    Lib "netapi32.dll" ( _
    vServername As Any, _
    ByVal lLevel As Long, _
    vBufptr As Any, _
    lPrefmaxlen As Long, _
    lEntriesRead As Long, _
    lTotalEntries As Long, _
    vServerType As Any, _
    ByVal sDomain As String, _
    vResumeHandle As Any) As Long
    
Private Declare Function NetWkstaGetInfo100 _
    Lib "netapi32" _
    Alias "NetWkstaGetInfo" ( _
    Servername As Byte, _
    ByVal Level As Long, _
    bufptr As Any) As Long
    
Private Declare Function NetServerGetInfo _
    Lib "netapi32" ( _
    Servername As Byte, _
    ByVal Level As Long, _
    bufptr As Any) As Long
    
Private Declare Function NetuserGetInfo _
    Lib "netapi32" ( _
    Servername As Byte, _
    Username As Byte, _
    ByVal Level As Long, _
    bufptr As Any) As Long

Private Declare Sub lstrcpyW _
    Lib "Kernel32" ( _
    vDest As Any, _
    ByVal sSrc As Any)

Private Declare Function NetGetDCName _
    Lib "netapi32.dll" ( _
    Servername As Byte, _
    DomainName As Byte, _
    DCNPtr As Long) As Long

Private Declare Function NetAPIBufferFree _
    Lib "netapi32.dll" _
    Alias "NetApiBufferFree" ( _
    ByVal Ptr As Long) As Long

Private Declare Function NetAPIBufferAllocate _
    Lib "netapi32.dll" _
    Alias "NetApiBufferAllocate" ( _
    ByVal ByteCount As Long, _
    Ptr As Long) As Long

Private Declare Function PtrToStr _
    Lib "Kernel32" _
    Alias "lstrcpyW" ( _
    RetVal As Byte, _
    ByVal Ptr As Long) As Long

Private Declare Function StrToPtr _
    Lib "Kernel32" _
    Alias "lstrcpyW" ( _
    ByVal Ptr As Long, _
    Source As Byte) As Long

Private Declare Function PtrToInt _
    Lib "Kernel32" _
    Alias "lstrcpynW" ( _
    RetVal As Any, _
    ByVal Ptr As Long, _
    ByVal nCharCount As Long) As Long

Private Declare Function StrLen _
    Lib "Kernel32" _
    Alias "lstrlenW" ( _
    ByVal Ptr As Long) As Long

Private Declare Function GetUserName _
    Lib "advapi32.dll" _
    Alias "GetUserNameA" ( _
    ByVal lpBuffer As String, _
    nSize As Long) As Long

Private Declare Function GetComputerName _
    Lib "Kernel32" _
    Alias "GetComputerNameA" ( _
    ByVal lpBuffer As String, _
    nSize As Long) As Long

Private Declare Function GetLastError _
    Lib "Kernel32" () As Long

Private Declare Function FormatMessage _
    Lib "Kernel32" _
    Alias "FormatMessageA" ( _
    ByVal dwFlags As Long, _
    lpSource As Any, _
    ByVal dwMessageId As Long, _
    ByVal dwLanguageId As Long, _
    ByVal lpBuffer As String, _
    ByVal nSize As Long, _
    Arguments As Long) As Long

Private Declare Function NetUserAdd2 _
    Lib "netapi32.dll" _
    Alias "NetUserAdd" ( _
    Servername As Byte, _
    ByVal Level As Long, _
    Buffer As USER_INFO_2, _
    ParmError As Long) As Long

Private Declare Sub CopyMem Lib "Kernel32" _
    Alias "RtlMoveMemory" ( _
    pTo As Any, _
    uFrom As Any, _
    ByVal lSize As Long)

Private Declare Function NetUserEnum0 Lib "netapi32.dll" _
    Alias "NetUserEnum" ( _
    Servername As Byte, _
    ByVal Level As Long, _
    ByVal IFilter As Long, _
    Buffer As Long, _
    ByVal PrefMaxLen As Long, _
    EntriesRead As Long, _
    TotalEntries As Long, _
    ResumeHandle As Long) As Long

Private Declare Function NetUserGetInfo20 Lib "netapi32.dll" _
    Alias "NetUserGetInfo" ( _
    Servername As Byte, _
    Username As Byte, _
    ByVal Level As Long, _
    Buffer As Any) As Long

Private Declare Function NetGroupGetInfo1 Lib "netapi32.dll" _
    Alias "NetGroupGetInfo" ( _
    Servername As Byte, _
    GroupName As Byte, _
    ByVal Level As Long, _
    Buffer As Any) As Long

Private Declare Function NetLocalGroupGetInfo1 Lib "netapi32.dll" _
    Alias "NetLocalGroupGetInfo" ( _
    Servername As Byte, _
    GroupName As Byte, _
    ByVal Level As Long, _
    Buffer As Any) As Long

Private Declare Function NetGroupEnumUsers0 Lib "netapi32.dll" _
    Alias "NetGroupGetUsers" ( _
    Servername As Byte, _
    GroupName As Byte, _
    ByVal Level As Long, _
    Buffer As Long, _
    ByVal PrefMaxLen As Long, _
    Entries As Long, _
    TotalEntries As Long, _
    ResumeHandle As Long) As Long

Private Declare Function NetGroupEnum0 Lib "netapi32.dll" _
    Alias "NetGroupEnum" ( _
    Servername As Byte, _
    ByVal Level As Long, _
    Buffer As Long, _
    ByVal PrefMaxLen As Long, _
    EntriesRead As Long, _
    TotalEntries As Long, _
    ResumeHandle As Long) As Long

Private Declare Function NetLocalGroupEnum0 Lib "netapi32.dll" _
    Alias "NetLocalGroupEnum" ( _
    Servername As Byte, _
    ByVal Level As Long, _
    Buffer As Long, _
    ByVal PrefMaxLen As Long, _
    EntriesRead As Long, _
    TotalEntries As Long, _
    ResumeHandle As Long) As Long

Private Declare Function NetUserGetGroups0 Lib "netapi32.dll" _
    Alias "NetUserGetGroups" ( _
    Servername As Byte, _
    Username As Byte, _
    ByVal Level As Long, _
    Buffer As Long, _
    ByVal PrefMaxLen As Long, _
    EntriesRead As Long, _
    TotalEntries As Long) As Long

Private Declare Function NetUserGetLocalGroups0 Lib "netapi32.dll" _
    Alias "NetUserGetLocalGroups" ( _
    Servername As Byte, _
    Username As Byte, _
    ByVal Level As Long, _
    ByVal Flags As Long, _
    Buffer As Long, _
    ByVal PrefMaxLen As Long, _
    EntriesRead As Long, _
    TotalEntries As Long) As Long
    
Public Function GetDomainName() As String

'
' Determine the Domain name using NetWkstaGetInfo
'

Dim lReturn As Long
Dim lTemp As Long
Dim sTemp As String
Dim aDomain(99) As Byte
Dim aServer() As Byte
Dim lBuffPtr As Long
Dim ptrWksta As WKSTA_INFO_100

    GetDomainName = ""
    
    aServer = "" + vbNullChar
    
    lReturn = NetWkstaGetInfo100( _
        aServer(0), _
        WKSTA_LEVEL_100, _
        lBuffPtr)
        
    If lReturn <> 0 Then
        'MsgBox NetErrorMsg
        Exit Function
    End If
        
    CopyMem ptrWksta, _
        ByVal lBuffPtr, _
        Len(ptrWksta)
        
    lTemp = ptrWksta.ptr_langroup
    
    lReturn = PtrToStr( _
        aDomain(0), _
        lTemp)
        
    sTemp = Left( _
        aDomain, _
        StrLen(lTemp))

    GetDomainName = sTemp
    
End Function
Public Function GetServerComment( _
    sServer As String) As String

'
' Determine the server comment using
' NetServerGetInfo
'

Dim lReturn As Long
Dim lTemp As Long
Dim sTemp As String
Dim aComment(99) As Byte
Dim aServer() As Byte
Dim lBuffPtr As Long
Dim ptrServer As SERVER_INFO_101

    GetServerComment = ""
    
    aServer = sServer + vbNullChar
    
    lReturn = NetServerGetInfo( _
        aServer(0), _
        SERVER_LEVEL_101, _
        lBuffPtr)
        
    If lReturn <> 0 Then
        MsgBox NetErrorMsg
        Exit Function
    End If
        
    CopyMem ptrServer, _
        ByVal lBuffPtr, _
        Len(ptrServer)
        
    lTemp = ptrServer.ptr_comment
    
    lReturn = PtrToStr( _
        aComment(0), _
        lTemp)
        
    sTemp = Left( _
        aComment, _
        StrLen(lTemp))

    GetServerComment = sTemp
    
End Function
Public Function GetServerType( _
    sServer As String) As String

'
' Determine the server type using
' NetServerGetInfo
'

Dim lReturn As Long
Dim lTemp As Long
Dim sTemp As String
Dim aServer() As Byte
Dim lBuffPtr As Long
Dim ptrServer As SERVER_INFO_101

    GetServerType = ""
    
    aServer = sServer + vbNullChar
    
    lReturn = NetServerGetInfo( _
        aServer(0), _
        SERVER_LEVEL_101, _
        lBuffPtr)
        
    If lReturn <> 0 Then
        MsgBox NetErrorMsg
        Exit Function
    End If
        
    CopyMem ptrServer, _
        ByVal lBuffPtr, _
        Len(ptrServer)
        
    lTemp = ptrServer.dw_type
    
    sTemp = Hex$(lTemp)
    If Len(sTemp) > 1 Then
        sTemp = Right$(sTemp, 2)
        If InStr(BDC_BIT, Left$(sTemp, 1)) Then
            GetServerType = "Backup"
        End If
    End If

    sTemp = Hex$(lTemp)
    If Len(sTemp) > 0 Then
        sTemp = Right$(sTemp, 1)
        If InStr(PDC_BIT, sTemp) Then
            GetServerType = "Primary"
        End If
    End If
    
End Function
Public Function GetServerVersion( _
    sServer As String) As String

'
' Determine the server version using
' NetServerGetInfo
'

Dim lReturn As Long
Dim lTemp As Long
Dim sTemp As String
Dim aServer() As Byte
Dim lBuffPtr As Long
Dim ptrServer As SERVER_INFO_101

    GetServerVersion = ""
    
    aServer = sServer + vbNullChar
    
    lReturn = NetServerGetInfo( _
        aServer(0), _
        SERVER_LEVEL_101, _
        lBuffPtr)
        
    If lReturn <> 0 Then
        MsgBox NetErrorMsg
        Exit Function
    End If
        
    CopyMem ptrServer, _
        ByVal lBuffPtr, _
        Len(ptrServer)
        
    lTemp = ptrServer.dw_ver_major
    
    sTemp = "V " & Trim$(Str$(lTemp)) & "."
    
    lTemp = ptrServer.dw_ver_minor
    
    sTemp = sTemp & Trim$(Str$(lTemp))
    
    GetServerVersion = sTemp
    
End Function
Public Function GetLocalComputerName() As String

'
' Determine the Computer name using NetWkstaGetInfo
'

Dim lReturn As Long
Dim lTemp As Long
Dim sTemp As String
Dim aComputer(99) As Byte
Dim aServer() As Byte
Dim lBuffPtr As Long
Dim ptrWksta As WKSTA_INFO_100

    GetLocalComputerName = ""
    
    aServer = "" + vbNullChar
    
    lReturn = NetWkstaGetInfo100( _
        aServer(0), _
        WKSTA_LEVEL_100, _
        lBuffPtr)
        
    If lReturn <> 0 Then
        'MsgBox NetErrorMsg
        Exit Function
    End If
        
    CopyMem ptrWksta, _
        ByVal lBuffPtr, _
        Len(ptrWksta)
        
    lTemp = ptrWksta.ptr_computername
    
    lReturn = PtrToStr( _
        aComputer(0), _
        lTemp)
        
    sTemp = Left( _
        aComputer, _
        StrLen(lTemp))

    GetLocalComputerName = sTemp
    
End Function
Public Function GetPDCName( _
    sServer As String, _
    sDomain As String) As String

'
' Get the PDC name for the given domain
'

Dim lResult As Long
Dim sDCName As String
Dim lDCNPtr As Long
Dim DNArray() As Byte
Dim MNArray() As Byte
Dim DCNArray(100) As Byte

    GetPDCName = ""
    
    MNArray = sServer & vbNullChar
    DNArray = sDomain & vbNullChar
    lResult = NetGetDCName( _
        MNArray(0), _
        DNArray(0), _
        lDCNPtr)
    
    If lResult <> 0 Then
        'MsgBox "Error " & _
        'lResult & _
        '" obtaining the Domain controller for Domain " & _
        'sDomain, _
        'vbOKOnly + vbExclamation
        Exit Function
    End If
    
    lResult = PtrToStr(DCNArray(0), lDCNPtr)
    lResult = NetAPIBufferFree(lDCNPtr)
    sDCName = DCNArray()
    GetPDCName = sDCName

End Function

Public Function NetErrorMsg() As String

Dim lReturn As Long
Dim sTemp As String

    sTemp = Space$(255)
    lReturn = FormatMessage( _
        FORMAT_MESSAGE_ALLOCATE_BUFFER + _
        FORMAT_MESSAGE_FROM_STRING, _
        Null, _
        10, _
        LANG_ENGLISH + SUBLANG_ENGLISH_UK, _
        sTemp, _
        Len(sTemp), _
        0)
        
    sTemp = Mid$( _
        sTemp, 1, InStr( _
        sTemp, Chr$(0)) - 1)

    NetErrorMsg = sTemp
End Function
Public Function GetUserFullname( _
    ByVal sUser As String, _
    ByVal sServer As String) As String

Dim lResult As Long
Dim lBufPtr As Long
Dim UArray() As Byte
Dim SArray() As Byte
Dim aFullname(99) As Byte
Dim ptrBuff As TUser20
Dim sTemp As String
Dim lTemp As Long

    UArray = sUser & vbNullChar
    SArray = sServer & vbNullChar

    lResult = NetUserGetInfo20( _
        SArray(0), _
        UArray(0), _
        20, _
        lBufPtr)

    CopyMem ptrBuff, _
        ByVal lBufPtr, _
        Len(ptrBuff)

    lTemp = ptrBuff.usri20_Full_name
    lResult = PtrToStr( _
        aFullname(0), _
        lTemp)
    sTemp = Left( _
        aFullname, _
        StrLen(lTemp))
   
'    lResult = PtrToStr(sTemp, lTemp)
    lResult = NetAPIBufferFree(lTemp)
    GetUserFullname = sTemp
         
    
    
'    sTemp = Hex$(lTemp)
'    If Len(sTemp) > 1 Then
'        sTemp = Right$(sTemp, 2)
'        If InStr(LOCKED_BIT, Left$(sTemp, 1)) Then
'            MsgBox "User " & sUser & " is locked out"
'        End If
'    End If''

'    sTemp = Hex$(lTemp)
'    If Len(sTemp) > 0 Then
'        sTemp = Right$(sTemp, 1)
'        If InStr(DISABLED_BIT, sTemp) Then
'            MsgBox "User " & sUser & " is disabled"
'        End If
'    End If
End Function
Public Function GetLastLogon( _
    ByVal sUser As String, _
    ByVal sServer As String) As Long

Dim lResult As Long
Dim lBufPtr As Long
Dim UArray() As Byte
Dim SArray() As Byte
Dim ptrBuff As USER_INFO_2
Dim sTemp As String
Dim lTemp As Long
Dim lLocked As Long
Dim lDisabled As Long

    lDisabled = False
    lLocked = False
    
    UArray = sUser & vbNullChar
    SArray = sServer & vbNullChar

    lResult = NetUserGetInfo20( _
        SArray(0), _
        UArray(0), _
        USER_LEVEL_2, _
        lBufPtr)

    CopyMem ptrBuff, _
        ByVal lBufPtr, _
        Len(ptrBuff)

    lTemp = ptrBuff.dw_last_logon

    'If lTemp = 0 Then
    '    sTemp = ""
    'Else
    '    sTemp = FormatDate(lTemp)
    'End If
    
    GetLastLogon = lTemp
    
End Function

Public Function GetLastLogoff( _
    ByVal sUser As String, _
    ByVal sServer As String) As String

Dim lResult As Long
Dim lBufPtr As Long
Dim UArray() As Byte
Dim SArray() As Byte
Dim ptrBuff As USER_INFO_2
Dim sTemp As String
Dim lTemp As Long

    UArray = sUser & vbNullChar
    SArray = sServer & vbNullChar

    lResult = NetUserGetInfo20( _
        SArray(0), _
        UArray(0), _
        USER_LEVEL_2, _
        lBufPtr)

    CopyMem ptrBuff, _
        ByVal lBufPtr, _
        Len(ptrBuff)

    lTemp = ptrBuff.dw_last_logoff

    If lTemp = 0 Then
        GetLastLogoff = "<none>"
    Else
        GetLastLogoff = FormatDate(lTemp)
    End If
    
End Function
Function FormatDate(ldate As Long) As String

    FormatDate = Format$( _
        DateAdd( _
            "s", _
            ldate, _
            "1-jan-1970"), _
        "dd-mmm-yyyy hh:mm")
    
End Function
Public Function EnumerateUsersByDate( _
    ByVal SName As String, _
    ByVal GName As String, _
    ByVal lDays As Integer) As String

'
' If a group name is used, must be Global not local
'
' Buffer filled from left with pointers to user names
' filled from right:-
'
'   ptr1|ptr2|...|ptrn|<garbage>|strn|...|str2|str1

Dim lResult As Long
Dim lBufPtr As Long
Dim lEntriesRead As Long
Dim lTotalEntries As Long
Dim lResumehandle As Long
Dim lBufLen As Long
Dim SNArray() As Byte
Dim GNArray() As Byte
Dim UNArray(99) As Byte
Dim sUName As String
Dim i As Integer
Dim lUNPtr As Long
Dim TempPtr As MungeLong
Dim TempStr As MungeInt
Dim sLogon As String
Dim sUsers As String
Dim aUsers() As Byte
Dim sServers As String

    EnumerateUsersByDate = ""
    sServers = EnumerateServers( _
        SV_TYPE_DOMAIN_BACKUP)
        
    SNArray = SName & vbNullChar
    GNArray = GName & vbNullChar
    lBufLen = 255
    lResumehandle = 0
    
    Do
        If GName = "" Then
            lResult = NetUserEnum0( _
                SNArray(0), _
                0, _
                FILTER_NORMAL_ACCOUNT, _
                lBufPtr, _
                lBufLen, _
                lEntriesRead, _
                lTotalEntries, _
                lResumehandle)
        Else
            lResult = NetGroupEnumUsers0( _
                SNArray(0), _
                GNArray(0), _
                0, _
                lBufPtr, _
                lBufLen, _
                lEntriesRead, _
                lTotalEntries, _
                lResumehandle)
        End If
        
        'EnumerateUsers = lResult
        
        If lResult <> 0 And lResult <> 234 Then
            EnumerateUsersByDate = _
                "*** Error " + Str$(lResult)
            Exit Function
        End If
        
        For i = 1 To lEntriesRead
            lResult = PtrToInt( _
                TempStr.xLo, _
                lBufPtr + (i - 1) * 4, _
                2)
            lResult = PtrToInt( _
                TempStr.xHi, _
                lBufPtr + (i - 1) * 4 + 2, _
                2)
            LSet TempPtr = TempStr
            lResult = PtrToStr( _
                UNArray(0), _
                TempPtr.x)
            sUName = Left( _
                UNArray, _
                StrLen(TempPtr.x))
            If LoggedOnBefore(sUName, _
                SName, _
                sServers, _
                lDays) Then
                sUsers = sUsers + sUName + ","
            End If
        Next i
        
    Loop Until lEntriesRead = lTotalEntries
    
    lResult = NetAPIBufferFree(lBufPtr)
    
    EnumerateUsersByDate = sUsers
    
End Function
Public Function EnumerateLockedUsers( _
    ByVal SName As String, _
    ByVal GName As String) As String

'
' If a group name is used, must be Global not local
'
' Buffer filled from left with pointers to user names
' filled from right:-
'
'   ptr1|ptr2|...|ptrn|<garbage>|strn|...|str2|str1

Dim lResult As Long
Dim lBufPtr As Long
Dim lEntriesRead As Long
Dim lTotalEntries As Long
Dim lResumehandle As Long
Dim lBufLen As Long
Dim SNArray() As Byte
Dim GNArray() As Byte
Dim UNArray(99) As Byte
Dim sUName As String
Dim i As Integer
Dim lUNPtr As Long
Dim TempPtr As MungeLong
Dim TempStr As MungeInt
Dim sFullName As String
'Dim itmX As ListItem
Dim sLogon As String
Dim sUsers As String
Dim aUsers() As Byte


    EnumerateLockedUsers = ""
    SNArray = SName & vbNullChar
    GNArray = GName & vbNullChar
    lBufLen = 255
    lResumehandle = 0
    
    Do
        If GName = "" Then
            lResult = NetUserEnum0( _
                SNArray(0), _
                0, _
                FILTER_NORMAL_ACCOUNT, _
                lBufPtr, _
                lBufLen, _
                lEntriesRead, _
                lTotalEntries, _
                lResumehandle)
        Else
            lResult = NetGroupEnumUsers0( _
                SNArray(0), _
                GNArray(0), _
                0, _
                lBufPtr, _
                lBufLen, _
                lEntriesRead, _
                lTotalEntries, _
                lResumehandle)
        End If
        
        'EnumerateUsers = lResult
        
        If lResult <> 0 And lResult <> 234 Then
            MsgBox "Error " & lResult & _
                " enumerating user " & _
                lEntriesRead & " of " & _
                lTotalEntries, _
                vbOKOnly + vbExclamation
            If lResult = 2220 Then MsgBox _
                "There is no Global group " & _
                GName, _
                vbOKOnly + vbExclamation
            Exit Function
        End If
        
        For i = 1 To lEntriesRead
            lResult = PtrToInt( _
                TempStr.xLo, _
                lBufPtr + (i - 1) * 4, _
                2)
            lResult = PtrToInt( _
                TempStr.xHi, _
                lBufPtr + (i - 1) * 4 + 2, _
                2)
            LSet TempPtr = TempStr
            lResult = PtrToStr( _
                UNArray(0), _
                TempPtr.x)
            sUName = Left( _
                UNArray, _
                StrLen(TempPtr.x))
            If AccountIsLocked(sUName, SName) Then
                sUsers = sUsers + sUName + ","
            End If
        Next i
        
    Loop Until lEntriesRead = lTotalEntries
    
    lResult = NetAPIBufferFree(lBufPtr)
    
    EnumerateLockedUsers = sUsers
    
End Function
Public Function AccountIsLocked( _
    ByVal sUser As String, _
    ByVal sServer As String) As Long

Dim lResult As Long
Dim lBufPtr As Long
Dim UArray() As Byte
Dim SArray() As Byte
Dim aFullname(99) As Byte
Dim ptrBuff As TUser20
Dim sTemp As String
Dim lTemp As Long

    AccountIsLocked = False
    UArray = sUser & vbNullChar
    SArray = sServer & vbNullChar

    lResult = NetUserGetInfo20( _
        SArray(0), _
        UArray(0), _
        20, _
        lBufPtr)

    CopyMem ptrBuff, _
        ByVal lBufPtr, _
        Len(ptrBuff)

    lTemp = ptrBuff.usri20_flags

    sTemp = Hex$(lTemp)
    If Len(sTemp) > 1 Then
        sTemp = Right$(sTemp, 2)
        If InStr(LOCKED_BIT, Left$(sTemp, 1)) Then
            AccountIsLocked = True
        End If
    End If ''

'    sTemp = Hex$(lTemp)
'    If Len(sTemp) > 0 Then
'        sTemp = Right$(sTemp, 1)
'        If InStr(DISABLED_BIT, sTemp) Then
'            MsgBox "User " & sUser & " is disabled"
'        End If
'    End If

End Function
Public Function AccountIsDisabled( _
    ByVal sUser As String, _
    ByVal sServer As String) As Long

Dim lResult As Long
Dim lBufPtr As Long
Dim UArray() As Byte
Dim SArray() As Byte
Dim aFullname(99) As Byte
Dim ptrBuff As TUser20
Dim sTemp As String
Dim lTemp As Long

    AccountIsDisabled = False
    UArray = sUser & vbNullChar
    SArray = sServer & vbNullChar

    lResult = NetUserGetInfo20( _
        SArray(0), _
        UArray(0), _
        20, _
        lBufPtr)

    CopyMem ptrBuff, _
        ByVal lBufPtr, _
        Len(ptrBuff)

    lTemp = ptrBuff.usri20_flags

    sTemp = Hex$(lTemp)
    
'    If Len(sTemp) > 1 Then
'        sTemp = Right$(sTemp, 2)
'        If InStr(LOCKED_BIT, Left$(sTemp, 1)) Then
'            AccountIsLocked = True
'        End If
'    End If ''

    If Len(sTemp) > 0 Then
        sTemp = Right$(sTemp, 1)
        If InStr(DISABLED_BIT, sTemp) Then
            AccountIsDisabled = True
        End If
    End If

End Function
Public Function LoggedOnBefore( _
    ByVal sUser As String, _
    sPdc As String, _
    ByVal sServers As String, _
    ByVal ldate As Long) As Long
    
Dim lResult As Long
Dim sTemp As String
Dim lTemp As Long
Dim sServer As String
Dim lLogon As Long
Dim lOldLogon As Long
Dim lPos1 As Long
Dim lPos2 As Long
Dim lCount As Long
Dim sDate

    LoggedOnBefore = False

'
' try PDC first
'

    lOldLogon = GetLastLogon(sUser, sPdc)
    lLogon = lOldLogon
    If Trim$(sServers) = "" Then GoTo no_bdc
    
'
' Loop through all BDCs
'
    
    lPos1 = 1
    lPos2 = 0
    lCount = 0

'
' Get the list of users, and how many - also use this to see
' if the user is to be skipped
'

    Do

        lPos2 = InStr(lPos1, sServers, ",")
        sTemp = Mid$(slocked, lPos1, lPos2 - lPos1)

        lLogon = GetLastLogon(sUser, sTemp)
        If lLogon > lOldLogon Then lOldLogon = lLogon
        
        lPos1 = lPos2 + 1

    Loop Until lPos1 >= Len(sServers)

no_bdc:

    sDate = DateSerial(Format$(FormatDate(lLogon), "yyyy"), Format$(FormatDate(lLogon), "mm"), Format$(FormatDate(lLogon), "dd"))
    If sDate < DateSerial(Format$(Now, "yyyy"), Format$(Now, "mm"), Format$(Now, "dd") - lDays) Then
        LoggedOnBefore = True
    Else
        LoggedOnBefore = False
    End If
    
    
End Function
Public Function EnumerateServers( _
    ByVal lType As Long)

Dim lReturn As Long
Dim Server_Info As Long
Dim lEntries As Long
Dim lTotal As Long
Dim lMax As Long
Dim vResume As Variant
Dim tServer_info_101 As SERVER_INFO_101
Dim sServer As String
Dim sDomain As String
Dim lServerInfo101StructPtr As Long
Dim x As Long, i As Long
Dim bBuffer(512) As Byte
Dim sServerList As String

    EnumerateServers = ""
    sServerList = ""
    sServer = vbNullString
               
    lReturn = NetServerEnum( _
        ByVal 0&, _
        101, _
        Server_Info, _
        lMax, _
        lEntries, _
        lTotal, _
        ByVal lType, _
        sDomain, _
        vResume)
    
    If lReturn <> 0 Then
        Exit Function
    End If
        
    x = 1
    lServerInfo101StructPtr = Server_Info
    
    Do While x <= lTotal
    
        RtlMoveMemory _
            tServer_info_101, _
            ByVal lServerInfo101StructPtr, _
            Len(tServer_info_101)
        
        lstrcpyW bBuffer(0), _
            tServer_info_101.ptr_name
        i = 0
        Do While bBuffer(i) <> 0
            sServer = sServer & _
                Chr$(bBuffer(i))
            i = i + 2
        Loop
        sServerList = sServerList + sServer + ","
        
        sServer = ""
        x = x + 1
        
        lServerInfo101StructPtr = _
            lServerInfo101StructPtr + _
            Len(tServer_info_101)
        
    Loop
    
    lReturn = NetAPIBufferFree(Server_Info)
    
    EnumerateServers = sServerList

End Function


