Attribute VB_Name = "basMain"
' ++
' Project:  WinSched
' Author:   Andy Doran (andy.doran@dial.pipex.com)
' Date:     September 1998
' Abstract:
'
'           This VB project shows a few things relating to
'           Win32 API calls for service control and job
'           scheduling and enumeration of servers.
'
'           Service control is used to ensure the Schedule
'           service is running (or to start it). Job control
'           is used in eumerating then adding/deleting jobs.
'           Server enumaration is used to browse for another
'           computer.
'
'           This is an example only - not fully functional as yet.
'           Things to be aware of:-
'
'       1)  I do not interpret or set values for days of the
'           month (ie 1st, 2nd, 28th etc.) that a job can run
'           on. Just too lazy!
'
'       2)  I only interpret flags for Each and Next
'
'       3)  No real checking is done on the input of the
'           schedule time. What I want is a time in the form
'           hh:mm - so just enter it carefully!
'
' --
Option Explicit

'
' Constants
'

Global sComputerName As String
Global sDomain As String

Global Const SC_MANAGER_CONNECT = &H1
Global Const SC_MANAGER_CREATE_SERVICE = &H2
Global Const SC_MANAGER_ENUMERATE_SERVICE = &H4
Global Const SC_MANAGER_LOCK = &H8
Global Const SC_MANAGER_QUERY_LOCK_STATUS = &H10
Global Const SC_MANAGER_MODIFY_BOOT_CONFIG = &H20
Global Const SC_MANAGER_ALL_ACCESS = SC_MANAGER_CONNECT + SC_MANAGER_CREATE_SERVICE + SC_MANAGER_ENUMERATE_SERVICE + SC_MANAGER_LOCK + SC_MANAGER_QUERY_LOCK_STATUS + SC_MANAGER_MODIFY_BOOT_CONFIG

Global Const SERVICE_QUERY_CONFIG = &H1
Global Const SERVICE_CHANGE_CONFIG = &H2
Global Const SERVICE_QUERY_STATUS = &H4
Global Const SERVICE_ENUMERATE_DEPENDENTS = &H8
Global Const SERVICE_START = &H10
Global Const SERVICE_STOP = &H20
Global Const SERVICE_PAUSE_CONTINUE = &H40
Global Const SERVICE_INTERROGATE = &H80
Global Const SERVICE_USER_DEFINED_CONTROL = &H100
Global Const SERVICE_ALL_ACCESS = SERVICE_QUERY_CONFIG + SERVICE_CHANGE_CONFIG + SERVICE_QUERY_STATUS + SERVICE_ENUMERATE_DEPENDENTS + SERVICE_STOP + SERVICE_START + SERVICE_PAUSE_CONTINUE + SERVICE_INTERROGATE + SERVICE_USER_DEFINED_CONTROL

Global Const SERVICE_STOPPED = 1
Global Const SERVICE_START_PENDING = 2
Global Const SERVICE_STOP_PENDING = 3
Global Const SERVICE_RUNNING = 4
Global Const SERVICE_CONTINUE_PENDING = 5
Global Const SERVICE_PAUSE_PENDING = 6
Global Const SERVICE_PAUSED = 7

Global Const SERVICE_BOOT_START = 0
Global Const SERVICE_SYSTEM_START = 1
Global Const SERVICE_AUTO_START = 2
Global Const SERVICE_DEMAND_START = 3
Global Const SERVICE_DISABLED = 4

Global Const SERVICE_CONTROL_STOP = 1
Global Const SERVICE_CONTROL_PAUSE = 2
Global Const SERVICE_CONTROL_CONTINUE = 3
Global Const SERVICE_CONTROL_INTERROGATE = 4
Global Const SERVICE_CONTROL_SHUTDOWN = 5

Global Const ERROR_MORE_DATA = 234
Global Const ERROR_ACCESS_DENIED = 5
Global Const ERROR_INVALID_HANDLE = 6
Global Const ERROR_PATH_NOT_FOUND = 3
Global Const ERROR_SERVICE_ALREADY_RUNNING = 1056
Global Const ERROR_DATABASE_LOCKED = 1055
Global Const ERROR_SERVICE_DEPENDENCY_DELETED = 1075
Global Const ERROR_SERVICE_DEPENDENCY_FAIL = 1068
Global Const ERROR_SERVICE_DISABLED = 1058
Global Const ERROR_SERVICE_LOGON_FAILED = 1069
Global Const ERROR_SERVICE_MARKED_FOR_DELETE = 1072
Global Const ERROR_SERVICE_NO_THREAD = 1054
Global Const ERROR_SERVICE_REQUEST_TIMEOUT = 1053
Global Const ERROR_SERVICE_DOES_NOT_EXIST = 1060
Global Const ERROR_SERVICE_CANNOT_ACCEPT_CONTROL = 1061
Global Const ERROR_SERVICE_NOT_ACTIVE = 1062
Global Const ERROR_SERVICE_SPECIFIC_ERROR = 1066
Global Const ERROR_SERVICE_START_HANG = 1070
Global Const ERROR_SERVICE_EXISTS = 1073
Global Const ERROR_SERVICE_NEVER_STARTED = 1077
Global Const ERROR_SERVICE_NOT_FOUND = 1243
Global Const ERROR_INSUFFICIENT_BUFFER = 122
Global Const ERROR_DATABASE_DOES_NOT_EXIST = 1065
Global Const ERROR_INVALID_PARAMETER = 87
Global Const ERROR_INVALID_NAME = 123

Global Const SERVICE_ACTIVE = &H1
Global Const SERVICE_INACTIVE = &H2
Global Const SERVICE_WIN32_OWN_PROCESS As Long = &H10
Global Const SERVICE_WIN32_SHARE_PROCESS As Long = &H20
Global Const SERVICE_WIN32 As Long = SERVICE_WIN32_OWN_PROCESS _
                  + SERVICE_WIN32_SHARE_PROCESS
 
Const JOB_RUN_PERIODICALLY = &H1
Const JOB_EXEC_ERROR = &H2
Const JOB_RUNS_TODAY = &H4
Const JOB_ADD_CURRENT_DATE = &H8
Const JOB_NONINTERACTIVE = &H10

'
' Type Declarations
'

Type AT_ENUM
    dw_JobId As Long
    dw_JobTime As Long
    dw_DaysOfMonth As Long
    dw_DaysOfWeek As Byte
    dw_Flags As Byte
    dw_dummy As Integer
    ptr_Command As Long
End Type

Type AT_INFO
    dw_JobTime As Long
    dw_DaysOfMonth As Long
    dw_DaysOfWeek As Byte
    dw_Flags As Byte
    dw_dummy As Integer
    ptr_Command As Long
End Type

Type SERVICE_STATUS
    dwServiceType As Long
    dwCurrentState As Long
    dwControlsAccepted As Long
    dwWin32ExitCode As Long
    dwServiceSpecificExitCode As Long
    dwCheckPoint As Long
    dwWaitHint As Long
End Type

Type QUERY_SERVICE_CONFIG
    dwServiceType As Long
    dwStartType As Long
    dwErrorControl As Long
    lpBinaryPathName As Long
    lpLoadOrderGroup As Long
    dwTagId As Long
    lpDependencies As Long
    lpServiceStartName As Long
    lpDisplayName As Long
End Type

Type ENUM_SERVICE_STATUS
    lpServiceName As Long
    lpDisplayName As Long
    ServiceStatus As SERVICE_STATUS
End Type

'
' Functions
'

Declare Function OpenSCManager _
    Lib "advapi32.dll" _
    Alias "OpenSCManagerA" ( _
    ByVal lpMachineName As String, _
    ByVal lpDatabaseName As String, _
    ByVal dwDesiredAccess As Long) As Long
    
Declare Function CloseServiceHandle _
    Lib "advapi32.dll" ( _
    ByVal hSCObject As Long) As Long

Declare Function OpenService _
    Lib "advapi32.dll" _
    Alias "OpenServiceA" ( _
    ByVal hSCManager As Long, _
    ByVal lpServiceName As String, _
    ByVal dwDesiredAccess As Long) As Long

Declare Function PtrToStr _
    Lib "Kernel32" _
    Alias "lstrcpyW" ( _
    RetVal As Byte, _
    ByVal Ptr As Long) As Long

Declare Function StrToPtr _
    Lib "Kernel32" _
    Alias "lstrcpyW" ( _
    ByVal Ptr As Long, _
    Source As Byte) As Long

Declare Function PtrToInt _
    Lib "Kernel32" _
    Alias "lstrcpynW" ( _
    RetVal As Any, _
    ByVal Ptr As Long, _
    ByVal nCharCount As Long) As Long

Declare Function StrLen _
    Lib "Kernel32" _
    Alias "lstrlenW" ( _
    ByVal Ptr As Long) As Long

Declare Function QueryServiceStatus _
    Lib "advapi32.dll" ( _
    ByVal hService As Long, _
    lpServiceStatus As Any) As Long

Declare Function StartService _
    Lib "advapi32.dll" _
    Alias "StartServiceA" ( _
    ByVal hService As Long, _
    ByVal dwNumServiceArgs As Long, _
    ByVal lpServiceArgVectors As Long) As Long

Declare Function QueryServiceConfig _
    Lib "advapi32.dll" _
    Alias "QueryServiceConfigA" ( _
    ByVal hService As Long, _
    lpServiceConfig As Any, _
    ByVal cbBufSize As Long, _
    pcbBytesNeeded As Long) As Long

Declare Function ControlService _
    Lib "advapi32.dll" ( _
    ByVal hService As Long, _
    ByVal dwControl As Long, _
    lpServiceStatus As Any) As Long

Declare Function EnumServicesStatus _
    Lib "advapi32.dll" _
    Alias "EnumServicesStatusA" ( _
    ByVal hSCManager As Long, _
    ByVal dwServiceType As Long, _
    ByVal dwServiceState As Long, _
    lpServices As Any, _
    ByVal cbBufSize As Long, _
    pcbBytesNeeded As Long, _
    lpServicesReturned As Long, _
    lpResumeHandle As Long) As Long
    
Declare Sub CopyMem Lib "Kernel32" _
    Alias "RtlMoveMemory" ( _
    pTo As Any, _
    uFrom As Any, _
    ByVal lSize As Long)
 
Declare Function NetScheduleJobGetInfo _
    Lib "netapi32" ( _
    Servername As Byte, _
    ByVal JobId As Long, _
    PointerToBuffer As Any) As Long

Declare Function NetScheduleJobEnum _
    Lib "netapi32" ( _
    Servername As Byte, _
    PointerToBuffer As Any, _
    PrefMaxLength As Long, _
    EntriesRead As Long, _
    TotalEntries As Long, _
    ResumeHandle As Long) As Long

Declare Function NetScheduleJobDel _
    Lib "netapi32" ( _
    Servername As Byte, _
    ByVal MinJobId As Long, _
    ByVal MaxJobId As Long) As Long

Declare Function NetScheduleJobAdd _
    Lib "netapi32" ( _
    Servername As Byte, _
    PointerToBuffer As AT_INFO, _
    JobInfo As Long) As Long
    
Declare Function NetAPIBufferFree _
    Lib "netapi32.dll" _
    Alias "NetApiBufferFree" ( _
    ByVal Ptr As Long) As Long

Declare Function NetAPIBufferAllocate _
    Lib "netapi32.dll" _
    Alias "NetApiBufferAllocate" ( _
    ByVal ByteCount As Long, _
    Ptr As Long) As Long
    
    
Declare Function GetLastError _
    Lib "kernel32.dll" () As Long

Public Declare Function SendMessageLong Lib "user32" Alias "SendMessageA" _
   (ByVal hwnd As Long, _
    ByVal Msg As Long, _
    ByVal wParam As Long, _
    ByVal lParam As Long) As Long

Public Const LVM_FIRST = &H1000
Public Const LVM_SETEXTENDEDLISTVIEWSTYLE = LVM_FIRST + 54
Public Const LVM_GETEXTENDEDLISTVIEWSTYLE = LVM_FIRST + 55

Public Const LVS_EX_FULLROWSELECT = &H20

' ++
' Function: GetScheduleInfo
' Action:   Return the state of the schedule service
' Input:    sComputer   -   Computer
' Output:   True/False
' --

Function GetScheduleInfo(sComputer As String) As Long

Dim lSCHandle As Long
Dim lSHandle As Long
Dim sState As String
Dim lReturn As Long


    GetScheduleInfo = False
    
'
' Connect to Service Control Manager
'

    lSCHandle = ConnectSCManager( _
        sComputer, _
        SC_MANAGER_CONNECT)
        
    If lSCHandle = False Then Exit Function
    
'
' Connect to Schedule service
'

    lSHandle = ConnectService( _
        lSCHandle, _
        "Schedule")
        
    If lSHandle = False Then Exit Function
    
'
' Get the service state
'

    sState = GetServiceState(lSHandle)
    
    If sState = "" Then
        MsgBox "Cannot determine the state of the Schedule service, program exiting", vbOKOnly + vbCritical
        Exit Function
    End If
    
    If sState = "Started" Then
        GetScheduleInfo = True
        Exit Function
    End If
    
    lReturn = CloseServiceHandle(lSHandle)
    lReturn = CloseServiceHandle(lSCHandle)
    
    frmMain.sbMain.Panels("Status").Text = "Schedule Service is Stopped"
    DoEvents
    
'
' Its stopped - ask to start it
'

    If MsgBox( _
        "The Schedule service is not running, start it (answering no will terminate the application)?" _
        , vbYesNo + vbQuestion) _
        <> vbYes Then Exit Function
    
'
' Reconnect to Service control manager and schedule service
' this time with enough rights to start it
'

    lSCHandle = ConnectSCManager( _
        sComputer, SC_MANAGER_ALL_ACCESS)
        
    If lSCHandle = False Then Exit Function
    
    lSHandle = ConnectService( _
        lSCHandle, _
        "Schedule")
        
    If lSHandle = False Then Exit Function
    
'
' Start the service
'

    lReturn = StartService(lSHandle, 0, 0)

    If lReturn = 0 Then
        MsgBox "Error " & _
            GetLastError & _
            " attempting to restart service"
    End If
    
'
' Wait for started
'

    frmMain.sbMain.Panels("Status").Text = "Waiting for Schedule Service to start..."
    DoEvents
    
    Do
        sState = GetServiceState(lSHandle)
        If sState = "Unknown" Then Exit Do
    Loop Until sState = "Started"
    
    If sState = "Started" Then _
        GetScheduleInfo = True

End Function

' ++
' Function: ConnectSCManager
' Action:   Connect to Service Control Manager
' Input:    sSystem     -   Server
'           lConnect    -   Long - how to connect (what access)
' Output:   Handle or False
' --

Private Function ConnectSCManager( _
    sSystem As String, _
    lConnect As Long) As Long


Dim lSCHandle As Long

'
' Try to connect to the remote Service Control Manager
'
    
    lSCHandle = OpenSCManager( _
        sSystem + vbNullString, _
        vbNullString, _
        lConnect)
    
    If lSCHandle = 0 Then
        ProcessError GetLastError, "Connecting to Service Control Manager"
        ConnectSCManager = False
    Else
        ConnectSCManager = lSCHandle
    End If
    
End Function
Private Sub ProcessError(lError, sAction)

'
' See what error was returned
'

    Select Case lError
    Case ERROR_ACCESS_DENIED
        MsgBox "Access denied, you may not have sufficient privileges", vbOKOnly + vbCritical, sAction
    Case ERROR_DATABASE_DOES_NOT_EXIST
        MsgBox "The database does not exist", vbOKOnly + vbCritical, sAction
    Case ERROR_INVALID_PARAMETER
        MsgBox "An invalid parameter was passed", vbOKOnly + vbCritical, sAction
        
    Case Else
        MsgBox "Unknown error number " & Str$(lError) & " encountered", vbOKOnly + vbCritical, sAction
    End Select
    
End Sub

' ++
' Function: GetStartState
' Action:   Find out what the startup state of a service is
' Input:    lHandle -   Handle to service
' Output:   String "Automatic" "Manual" etc.
' --

Private Function GetStartState( _
    lHandle As Long) As String

Dim pState() As QUERY_SERVICE_CONFIG
Dim lReturn As Long
Dim lBuffer As Long
Dim lBytesNeeded As Long
Dim lStructNeeded As Long

'
' Call first with not enough data
'

    lReturn = QueryServiceConfig( _
        lHandle, _
        ByVal &H0, _
        &H0, _
        lBytesNeeded)
        
    If GetLastError <> ERROR_INSUFFICIENT_BUFFER Then
        GetStartState = "Unknown"
        Exit Function
    End If
        
'
' Calculate the buffer sizes
'

    lStructNeeded = lBytesNeeded / Len(pState(0)) + 1
    
    ReDim pState(lStructNeeded - 1)
    lBuffer = lStructNeeded * Len(pState(0))
    
'
' Do the real call now
'

    lReturn = QueryServiceConfig( _
        lHandle, _
        pState(0), _
        lBuffer, _
        lBytesNeeded)
        
'
' get the info from pstate()
'

    Select Case pState(0).dwStartType
        Case SERVICE_BOOT_START
            GetStartState = "Boot"
        Case SERVICE_SYSTEM_START
            GetStartState = "System"
        Case SERVICE_AUTO_START
            GetStartState = "Automatic"
        Case SERVICE_DISABLED
            GetStartState = "Disabled"
        Case SERVICE_DEMAND_START
            GetStartState = "Manual"
        Case Else
            GetStartState = "Unknown"
    End Select

End Function

' ++
' Function: ConnectService
' Action:   Connect to a specific service
' Input:    lHandle     -   Handle to SCManager
'           ServiceName -   The service to connect to
' Output:   Handle or False
' --

Private Function ConnectService( _
    lHandle As Long, _
    ServiceName As String) As Long

Dim lSHandle As Long
Dim lReturn As Long


'
' Open the Service Name
'

    lSHandle = OpenService( _
        lHandle, _
        ServiceName, _
        SERVICE_ALL_ACCESS)

    If lSHandle = 0 Then
        MsgBox "Error " & Str$(GetLastError) & " connecting to service " & ServiceName, vbOKOnly + vbCritical
        lReturn = CloseServiceHandle(lHandle)
        ConnectService = False
    Else
        ConnectService = lSHandle
    End If

End Function

' ++
' Function: GetServiceState
' Action:   Find out what state a service is in
' Input:    lHandle -   Handle to the service
' Output    String "Started" "Stopped" "Paused"
' --

Function GetServiceState(lHandle As Long) As String

Dim pstatus As SERVICE_STATUS
Dim lReturn As Long

'
' Get the service state
'

    lReturn = QueryServiceStatus( _
        lHandle, _
        pstatus)

    If lReturn <> 1 Then
        MsgBox "Error " & Str$(GetLastError) & " querying the service"
        lReturn = CloseServiceHandle(lHandle)
        'lReturn = CloseServiceHandle(lSCHandle)
        GetServiceState = ""
    End If

    Select Case pstatus.dwCurrentState
    Case SERVICE_STOPPED
        GetServiceState = "Stopped"
    Case SERVICE_START_PENDING
        GetServiceState = "Start Pending"
    Case SERVICE_STOP_PENDING
        GetServiceState = "Stop Pending"
    Case SERVICE_RUNNING
        GetServiceState = "Started"
    Case SERVICE_CONTINUE_PENDING
        GetServiceState = "Continue Pending"
    Case SERVICE_PAUSE_PENDING
        GetServiceState = "Pause Pending"
    Case SERVICE_PAUSED
        GetServiceState = "Paused"
    Case Else
        GetServiceState = "Unknown"
    End Select


End Function

' ++
' Function: EnumJobs
' Action:   Enumerate all Jobs
' Input:    sComputer   -   Server
' Output:   True/False
' --

Function EnumJobs(sComputer As String) As Long


Dim aServer() As Byte
Dim aCommand(99) As Byte
Dim sCommand As String
Dim lReturn As Long
Dim ptrBuffer As AT_ENUM
Dim lBuffer As Long
Dim lResume As Long
Dim lEntriesRead As Long
Dim lTotalEntries As Long
Dim itmX As ListItem
Dim i As Long
Dim sTemp As String
Dim lTemp As Long
Dim lTempBuffer As Long
Dim lResult As Long
Dim sTime As String
Dim sDayInfo As String

    EnumJobs = False
    
'
' Convert server to unicode
'

    aServer() = sComputer & vbNullChar
    lResume = 0
    
    lReturn = NetScheduleJobEnum( _
        aServer(0), _
        lBuffer, _
        255, _
        lEntriesRead, _
        lTotalEntries, _
        lResume)
    
    lTempBuffer = lBuffer
    
'
' if lTempBuffer <> 0 then there are jobs
'

    If lTempBuffer <> 0 Then
        i = 1
        Do
    
'
' Dump info into AT_ENUM structure
'

            CopyMem ptrBuffer, _
                ByVal lTempBuffer, _
                Len(ptrBuffer)

'
' Job id is straightforward - put into lvJobs
'

            lTemp = ptrBuffer.dw_JobId
        
            Set itmX = frmMain.lvJobs.ListItems. _
                Add(, , Str$(lTemp))
        
'
' Command is a long pointer - need to convert to a string
'

            lTemp = ptrBuffer.ptr_Command
            lResult = PtrToStr( _
                aCommand(0), _
                lTemp)
            sCommand = Left( _
                aCommand, _
                StrLen(lTemp))
            itmX.SubItems(1) = sCommand
        
'
' Time is in milliseconds - must convert it
'

            sTime = ConvertTime(ptrBuffer.dw_JobTime)
            itmX.SubItems(3) = sTime

'
' Daysof week and month & flags must be interpreted
'

            sDayInfo = GetDayInfo( _
                ptrBuffer.dw_DaysOfMonth, _
                ptrBuffer.dw_DaysOfWeek, _
                ptrBuffer.dw_Flags)
           
            
            itmX.SubItems(2) = sDayInfo
            itmX.Icon = "Job"
            itmX.SmallIcon = "Job"
            i = i + 1
        
            lTempBuffer = _
                lTempBuffer + Len(ptrBuffer)
            
        Loop Until i > lTotalEntries
    End If
    
End Function
    
' ++
' Function: ConvertToBinary
' Action:   Convert a decimal to a binary string
' Input:    y   -   Decimal number
' Output:   String "010010010"
' --

Function ConvertToBinary(y As Long) As String

'
' This routine converts a decimal dumber to
' a binary string - the decimal number can
' be any number up to 32768

Dim lAns As Long, lNumber As Long
Dim sBinary As String
Dim x As Long

    x = Abs(y)
    sBinary = ""
'
' This is why the biggest number is 32768
'

    lNumber = 32768
    
'
' Loop around going through the number. Keep
' dividing by a multiple of 2 and using whats
' left over
'
    Do
    
 '
 ' Divide by a multiple of 2. Use \ as this
 ' returns an integer - should be 1 (is divisible)
 ' or 0 (is not divisible)
 '
 
        lAns = x \ lNumber
        
        If lAns = 1 Then
            
 '
 ' This means we put a bit in the binary string
 '
 
            sBinary = sBinary + "1"
            
 '
 ' Now use MOD to determine the remainder after the
 ' above division. We then use the remainder to
 ' continue the process.
 '
 
            x = x Mod lNumber
        
        Else
            
 '
 ' This means we put a 0 in the binary string
 '
 
            sBinary = sBinary + "0"
        
        End If
        
 '
 ' Now reduce the number we are dividing by (by
 ' dividing in half - next bit down!
 '
 
        lNumber = lNumber / 2
        
 '
 ' Check that we haven't gone too far (ie that the
 ' number we are dividing by is at least 1
 '
        
        If lNumber < 1 Then Exit Do
        
    Loop
    
    ConvertToBinary = sBinary
    
End Function

' ++
' Function: ConvertTime
' Action:   Convert Milliseconds (from midnight) to a real time
' Input:    lMSec   -   Milliseconds
' Output:   String "xx:xx:xx"
' --

Function ConvertTime(lMSec As Long) As String

Dim lSeconds As Long

    lSeconds = lMSec \ 1000
    ConvertTime = Format$( _
        DateAdd("s", lSeconds, "00:00"), "hh:mm:ss")
        
End Function

' ++
' Function: TimeToMilliseconds
' Action:   Convert time (12:22) to milliseconds from midnight
' Input:    sTime   -   Time
' Output:   Long (milliseconds from midnight)
' --

Function TimeToMilliseconds(sTime As String) As Long

    TimeToMilliseconds = ((Val(Left$(sTime, 2)) * 3600) + _
        (Val(Right$(sTime, 2)) * 60)) * 1000
        
End Function

' ++
' Function: GetDayInfo
' Action:   Interpret AT_ENUM to get schedule days
' Input:    lMonth  -   Days of month (as a long)
'           bDay    -   Days of week (as byte)
'           bFlag   -   Flags (as byte)
' Output:   Formatted ("Each Tue Thu")
'
' Note:     Currently DaysOfMonth NOT interpreted!
' For more info, see Win32API reference - AT_ENUM
' --

Function GetDayInfo( _
    lMonth As Long, _
    bDay As Byte, _
    bFlag As Byte) As String
    
Dim sMonth As String
Dim sDay As String
Dim sFlag As String
Dim sRun As String
Dim i As Long
Dim aDays(7) As String

    aDays(1) = "Mon"
    aDays(2) = "Tue"
    aDays(3) = "Wed"
    aDays(4) = "Thu"
    aDays(5) = "Fri"
    aDays(6) = "Sat"
    aDays(7) = "Sun"
    
'
' Get a binary string for each of the inputs
' This is because 1s and 0s are used to show the various
' flags & days that are used
' eg for bDay (converted to sDay)
'
'   0000001 = Sunday
'   0000010 = Saturday
'   0000011 = Saturday & Sunday
'

    sMonth = ConvertToBinary(lMonth)
    sDay = Right$(ConvertToBinary(Val(bDay)), 7)
    sFlag = Right$(ConvertToBinary(Val(bFlag)), 8)
    
'
' Interpret the binary string for Days
'

    sRun = ""
    For i = 7 To 1 Step -1
        If Mid$(sDay, i, 1) = "1" Then
            If sRun = "" Then
                sRun = aDays((7 - i) + 1)
            Else
                sRun = sRun + " " + aDays((7 - i) + 1)
            End If
        End If
    Next i
    
'
' Interpret flags - only ones used at present are Each and Next
'

    If Left$(sFlag, 1) = "1" Then
        sRun = "Next: " + sRun
    Else
        If Right$(sFlag, 1) = "1" Then
            sRun = "Each: " + sRun
        End If
    End If
            
    GetDayInfo = sRun
    
End Function

' ++
' Function: Mask
' Action:   Determine the outcome of a binary bitmask
' Input:    sHi -   Binary string
'           sLo -   Binary string (bitmask)
' Output:   binary string
' --

Function Mask(sHi, sLo) As String

Dim sTemp As String
Dim i As Long
Dim sHigh As String
Dim sLow As String

    sHigh = Right$(sHi, 7)
    sLow = Right$(sLo, 7)
    
    sTemp = ""
    
    For i = 1 To 7
    
        If Mid$(sHigh, i, 1) = "1" And _
            Mid$(sLow, i, 1) = "1" Then
            sTemp = sTemp + "1"
        Else
            sTemp = sTemp + "0"
        End If
    Next i
    
    Mask = sTemp
End Function

' ++
' Function: GetJobInfo
' Action:   Get full details for job
' Input:    sComputer   -   Server
'           lJob        -   Job id
' Output:   Nothing - just a message box at the moment
' --

Function GetJobInfo( _
    sComputer As String, _
    lJob As Long) As Long

Dim aServer() As Byte
Dim aCommand(99) As Byte
Dim sCommand As String
Dim lReturn As Long
Dim ptrBuffer As AT_INFO
Dim lBuffer As Long
Dim sTemp As String
Dim lTemp As Long
Dim lResult As Long
Dim sTime As String
Dim sDayInfo As String
    
    aServer() = sComputer & vbNullChar
    
    lReturn = NetScheduleJobGetInfo( _
        aServer(0), _
        lJob, _
        lBuffer)
    
    CopyMem ptrBuffer, _
        ByVal lBuffer, _
        Len(ptrBuffer)
        
        lTemp = ptrBuffer.ptr_Command
        lResult = PtrToStr( _
            aCommand(0), _
            lTemp)
        sCommand = Left( _
            aCommand, _
            StrLen(lTemp))
        sTime = ConvertTime(ptrBuffer.dw_JobTime)
        
        'sDayInfo = GetDayInfo( _
        '    ptrBuffer.dw_DaysOfMonth, _
        '    ptrBuffer.dw_DaysOfWeek, _
        '    ptrBuffer.dw_Flags)
       ' sDayInfo = Str$(ptrBuffer.dw_DaysOfMonth) + Chr$(13) + _
       '     Str$(ptrBuffer.uc_DaysOfWeek) + Chr$(13) + _
       '     Str$(ptrBuffer.uc_Flags)

    MsgBox sCommand + Chr$(13) + sTime + Chr$(13) + sDayInfo
    
End Function

' ++
' Function: DeleteJob
' Action:   Delete a job from the schedule
' Input:    sServer -   Server
'           lMin    -   Minimum Job id
'           lMax    -   Maximum Job id
' Output:   True/False
' --

Function DeleteJob( _
    sServer As String, _
    lMin As Long, _
    lMax As Long) As Long

Dim aServer() As Byte
Dim lReturn As Long

'
' Convert server to unicode
'

    aServer = sServer & vbNullChar
    
    lReturn = NetScheduleJobDel( _
        aServer(0), _
        lMin, _
        lMax)
        
    DeleteJob = lReturn = 0
    
End Function

'++
' Function: AddJob
' Action:   Add a job to the task scheduler
' Input:    sServer -   Server name
'           lTime   -   Time to submit job
'           lDom    -   Days of week (pre-formatted)
'           lDow    -   Days of week (pre-formatted)
'           lFlags  -   Flags (pre-formatted)
' Output:   True if ok
' --

Function AddJob( _
    sServer As String, _
    lTime As Long, _
    lDom As Long, _
    lDow As Long, _
    lFlags As Long, _
    sCmd) As Long

Dim aServer() As Byte
Dim lReturn As Long
Dim lJobReturn As Long
Dim bDoW As Byte
Dim bFlags As Byte
Dim tInfo As AT_INFO
Dim lJobid As Long
Dim lCmd As Long
Dim aCmd() As Byte
Dim lptr As Long
 
'
' Convert server and command to unicode, and Days of week/Flags to Byte
'

    aServer = sServer & vbNullChar
    aCmd = sCmd & vbNullChar
    bDoW = lDow
    bFlags = lFlags
    
'
' Allocate buffer space for command and turn to a long pointer
'

    lReturn = NetAPIBufferAllocate(UBound(aCmd) + 1, lCmd)
    
    lReturn = StrToPtr(lCmd, aCmd(0))
    
'
' Set up Job info structure
'

    tInfo.dw_JobTime = lTime
    tInfo.dw_DaysOfMonth = lDom
    tInfo.dw_DaysOfWeek = bDoW
    tInfo.dw_Flags = bFlags
    tInfo.ptr_Command = lCmd
       
'
' Make the call
'

    lJobReturn = NetScheduleJobAdd( _
        aServer(0), _
        tInfo, _
        lJobid)
    
    
'
' Clean up
'

    lReturn = NetAPIBufferFree(lCmd)
        
    AddJob = lJobReturn = 0
    
End Function

