Attribute VB_Name = "Module1"
'Following declarations were taken from
' Novell Libraries for Visual Basic
' available at http://developer.novell.com/ndk/download.htm

Public Const DS_ROOT_NAME = "[Root]"
   
Public Const DCK_FLAGS = 1
Public Const DCK_CONFIDENCE = 2
Public Const DCK_NAME_CONTEXT = 3
Public Const DCK_TRANSPORT_TYPE = 4
Public Const DCK_REFERRAL_SCOPE = 5
Public Const DCK_LAST_CONNECTION = 8
Public Const DCK_LAST_SERVER_ADDRESS = 9
Public Const DCK_LAST_ADDRESS_USED = 10
Public Const DCK_TREE_NAME = 11
Public Const DCK_DSI_FLAGS = 12
Public Const DCK_NAME_FORM = 13

Public Const NW_MAX_SERVER_NAME_LEN = 49
Public Const NW_MAX_TREE_NAME_LEN = 33

Public Const NWCC_MATCH_NOT_EQUALS = &H0
Public Const NWCC_MATCH_EQUALS = &H1
Public Const NWCC_RETURN_PUBLIC = &H2
Public Const NWCC_RETURN_PRIVATE = &H4
Public Const NWCC_RETURN_LICENSED = &H8
Public Const NWCC_RETURN_UNLICENSED = &H10

Public Const NWCC_OPEN_LICENSED = &H1
Public Const NWCC_OPEN_UNLICENSED = &H2
Public Const NWCC_RESERVED = &H0
  
Public Const NWCC_INFO_NONE = 0
Public Const NWCC_INFO_AUTHENT_STATE = 1
Public Const NWCC_INFO_BCAST_STATE = 2
Public Const NWCC_INFO_CONN_REF = 3
Public Const NWCC_INFO_TREE_NAME = 4
Public Const NWCC_INFO_CONN_NUMBER = 5
Public Const NWCC_INFO_USER_ID = 6
Public Const NWCC_INFO_SERVER_NAME = 7
Public Const NWCC_INFO_NDS_STATE = 8
Public Const NWCC_INFO_MAX_PACKET_SIZE = 9
Public Const NWCC_INFO_LICENSE_STATE = 10
Public Const NWCC_INFO_DISTANCE = 11
Public Const NWCC_INFO_SERVER_VERSION = 12
Public Const NWCC_INFO_TRAN_ADDR = 13
Public Const NWCC_INFO_RETURN_ALL = -1
Public Const NWCC_INFO_VERSION_1 = &H1
Public Const NWCC_INFO_VERSION_2 = &H2
Public Const NWCC_INFO_VERSION = NWCC_INFO_VERSION_1

Public Type NWCCTranAddrSTRUCT
    type As Long
    len As Long
    buffer As Long
End Type

Public Type NWCCVersionSTRUCT
    major As Long
    minor As Long
    revision As Long
End Type

Public Type NWCCConnInfoSTRUCT
    authenticationState As Long
    broadcastState As Long
    connRef As Long
    treeName(NW_MAX_TREE_NAME_LEN - 1) As Byte
    connNum As Long
    userID As Long
    serverName(NW_MAX_SERVER_NAME_LEN - 1) As Byte
    NDSState As Long
    maxPacketSize As Long
    licenseState As Long
    distance As Long
    serverVersion As NWCCVersionSTRUCT
    tranAddr As Long
End Type

Public Type Tree_Name_T
    tname(64) As Byte
End Type

Declare Function NWCallsInit Lib "calwin32" _
    (reserved1 As Byte, reserved2 As Byte) As Long

Declare Function NWCCOpenConnByRef Lib "clxwin32" _
    (ByVal connRef As Long, ByVal openState As Long, _
     ByVal reserved As Long, pConnHandle As Long) As Long

Declare Function NWCCCloseConn Lib "clxwin32" _
    (ByVal connHandle As Long) As Long

Declare Function NWGetObjectName Lib "calwin32" _
    (ByVal connHandle As Long, ByVal objID As Long, _
     ByVal objName As Long, objType As Integer) As Long

Declare Function NWCCScanConnRefs Lib "clxwin32" _
    (scanIterator As Long, connRef As Long) As Long

Declare Function NWCCGetAllConnRefInfo Lib "clxwin32" _
    (ByVal connRef As Long, ByVal connInfoVersion As Long, _
     connInfoBuffer As NWCCConnInfoSTRUCT) As Long

Declare Function NWDSCreateContextHandle Lib "NETWIN32" _
    (context As Long) As Long

Declare Function NWDSFreeContext Lib "NETWIN32" _
    (ByVal context As Long) As Long

Declare Function NWDSScanConnsForTrees Lib "NETWIN32" _
    (ByVal context As Long, ByVal numOfPtrs As Long, _
     numOfTrees As Long, treeBufPtrs As Long) As Long

Declare Function NWDSMapIDToName Lib "NETWIN32" _
    (ByVal context As Long, ByVal connHandle As Long, _
    ByVal objectID As Long, ByVal object1 As Long) As Long

Declare Function NWDSGetContext Lib "NETWIN32" _
    (ByVal context As Long, ByVal key As Long, _
     ByVal value As Long) As Long
     
Declare Function NWDSSetContext Lib "NETWIN32" _
    (ByVal context As Long, ByVal key As Long, _
     ByVal value As Long) As Long

Declare Function NWDSWhoAmI Lib "NETWIN32" _
    (ByVal context As Long, ByVal objectName As Long) As Long

