VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Begin VB.Form Form1 
   Caption         =   "Connection Information"
   ClientHeight    =   3600
   ClientLeft      =   1590
   ClientTop       =   2925
   ClientWidth     =   7335
   LinkTopic       =   "Form1"
   ScaleHeight     =   3600
   ScaleWidth      =   7335
   Begin VB.CommandButton Command1 
      Caption         =   "Refresh"
      Height          =   372
      Left            =   3000
      TabIndex        =   2
      Top             =   3120
      Width           =   1212
   End
   Begin ComctlLib.ListView ListView1 
      Height          =   2532
      Left            =   120
      TabIndex        =   0
      Top             =   480
      Width           =   7092
      _ExtentX        =   12515
      _ExtentY        =   4471
      View            =   3
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   327682
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   0
   End
   Begin ComctlLib.ImageList ImageList1 
      Left            =   5400
      Top             =   3120
      _ExtentX        =   794
      _ExtentY        =   794
      BackColor       =   -2147483643
      MaskColor       =   12632256
      _Version        =   327682
   End
   Begin VB.Label Label1 
      Caption         =   "You are attached to the following:"
      Height          =   252
      Left            =   240
      TabIndex        =   1
      Top             =   240
      Width           =   2652
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'================================================================
'Copyright  1998 Novell, Inc.  All Rights Reserved.
'
'  With respect to this file, Novell hereby grants to Developer a
'  royalty-free, non-exclusive license to include this sample code
'  and derivative binaries in its product. Novell grants to Developer
'  worldwide distribution rights to market, distribute or sell this
'  sample code file and derivative binaries as a component of
'  Developer 's product(s).  Novell shall have no obligations to
'  Developer or Developer's customers with respect to this code.
'
'DISCLAIMER:
'
'  Novell disclaims and excludes any and all express, implied, and
'  statutory warranties, including, without limitation, warranties
'  of good title, warranties against infringement, and the implied
'  warranties of merchantibility and fitness for a particular purpose.
'  Novell does not warrant that the software will satisfy customer's
'  requirements or that the licensed works are without defect or error
'  or that the operation of the software will be uninterrupted.
'  Novell makes no warranties respecting any technical services or
'  support tools provided under the agreement, and disclaims all other
'  warranties, including the implied warranties of merchantability and
'  fitness for a particular purpose.
'
'================================================================
'
' Project:    vbconinf.vbp
'
'   Desc: Sample code which  demonstrates how to use DLL function
'         calls in VB when getting all connection information about
'         the client connection.
'         The most important calls used: NWDSScanConnsForTrees(),
'         NWDSWhoAmI(), NWDSMapIDToName(), NWCCScanConnRefs(),
'         NWCCGetAllConnRefInfo(), NWCCOpenConnByRef() and NWGetObjectName().
'         This code produces output very similar to what you can get
'         from your Win95/WinNT client`s  "NetWare Connection" option.
'         No error handling is implemented to keep the code simple.
'
'   Programmers:
'
'   Ini       Who                 Firm
'   ------------------------------------------------------------------
'   RLE       Rostislav Letos     Novell DeveloperNet Labs
'
'   History:
'
'   When           Who     What
'   ------------------------------------------------------------------
'   98 December    RLE     Initial code
'
'=====================================================================

' It`s a good idea to have the following 'Option explicit' switched ON
'   to avoid unexpectable results from VB Variant types
'   whenever we need to call DLL functions
Option Explicit
Private Const APP_PATH = "f:\tids\conninfo\"    ' Path needs to be edited !

Private Sub ByteArrayToString(src() As Byte, dest As String)
Dim i As Integer
    i = 0
    dest = ""
    While src(i) <> 0
        dest = dest + Chr(src(i))
        i = i + 1
    Wend
End Sub

Private Sub StringToByteArray(src As String, dest() As Byte)
Dim i As Integer
' Following For-Next loop  should run to 0x0 char only
'   but we do not care if it runs longer
    For i = 0 To Len(src) - 1
        dest(i) = CByte(Asc(Mid(src, i + 1, 1)))
    Next i
End Sub

' This is the main procedure which makes all important DLL calls
'  and produces nice output
Private Sub GetConnections()
Dim retCode As Long, retCode2 As Long
Dim refIter As Long, connRef As Long
Dim connInfo As NWCCConnInfoSTRUCT
Dim tranAddr As NWCCTranAddrSTRUCT
Dim netAddr(63) As Byte, byteName(127) As Byte
Dim itmX As ListItem
Dim name As String, networkAddress As String
Dim hexString As String
Dim objType As Integer, i As Integer
Dim contextHandle As Long, treePointers(15) As Long
Dim treeNames(15) As Tree_Name_T
Dim numOfTrees As Long, connHandle As Long

' First of all we initiate ListView for outputs
    ListView1.View = lvwReport
    ListView1.ListItems.Clear
    ListView1.ColumnHeaders.Clear
    ListView1.ColumnHeaders.Add , , "Resource", ListView1.Width / 6
    ListView1.ColumnHeaders.Add , , "User Name", ListView1.Width / 6
    ListView1.ColumnHeaders.Add , , "Conn No", ListView1.Width / 12
    ListView1.ColumnHeaders.Add , , "Authentication State", ListView1.Width / 5
    ListView1.ColumnHeaders.Add , , "NDS Tree", ListView1.Width / 7
    ListView1.ColumnHeaders.Add , , "Trans Type", ListView1.Width / 12
    ListView1.ColumnHeaders.Add , , "Address", ListView1.Width / 3
    ListView1.SmallIcons = ImageList1

' Part I. - getting connected DS tree names
    retCode = NWDSCreateContextHandle(contextHandle)
    If retCode <> 0 Then
        MsgBox "NWDSCreateContextHandle failed, E=" + retCode, vbCritical
    Else
' I.a - We need to initialize structure for authenticated tree names
'       Let`s say there won`t be more then 16 trees...
        For i = 0 To 15
            treePointers(i) = VarPtr(treeNames(i).tname(0))
        Next i
' I.b - Following function searches for connected DS tree names
        retCode = NWDSScanConnsForTrees(contextHandle, 16, numOfTrees, treePointers(0))
        If retCode <> 0 Then
            MsgBox "NWDSScanConnsForTrees failed, E=" + retCode, vbCritical
        Else
            For i = 0 To numOfTrees - 1
                Call ByteArrayToString(treeNames(i).tname, name)
                Set itmX = ListView1.ListItems.Add(, , name, , 1)
' I.c - Now we have DS tree name and need to know our user name
'        in this DS tree
                Call StringToByteArray(name + Chr(0), byteName)
                retCode = NWDSSetContext(contextHandle, DCK_TREE_NAME, VarPtr(byteName(0)))
                retCode = NWDSWhoAmI(contextHandle, VarPtr(byteName(0)))
                Call ByteArrayToString(byteName, name)
                itmX.SubItems(1) = name
            Next i
        End If
    End If
    NWDSFreeContext (contextHandle)

' Part. II - getting connection, server names, ...
' II.a - we have to initiate some pointers we will utilize
    tranAddr.buffer = VarPtr(netAddr(0))
    connInfo.tranAddr = VarPtr(tranAddr.type)
' II.b - we will scan our connection reference table in loop
    refIter = 0
    Do
        retCode = NWCCScanConnRefs(refIter, connRef)
        If retCode = 0 Then
' II.c - for each existing reference number we ask for more information
'        Asking for NWCC_INFO_VERSION_2 also returns connection addresses
            tranAddr.len = 64     ' Needed for Win95 client, not for WinNT client !
            retCode2 = NWCCGetAllConnRefInfo(connRef, NWCC_INFO_VERSION_2, connInfo)
            If retCode2 = 0 Then
                If connInfo.authenticationState = 1 Or connInfo.authenticationState = 2 Then
                    i = 3
                Else
                    i = 2
                End If
                Call ByteArrayToString(connInfo.serverName, name)
                Set itmX = ListView1.ListItems.Add(, , name, , i)
' II.d - we need to map user`s ID to name - this depends on NetWare version
                retCode = NWCCOpenConnByRef(connRef, NWCC_OPEN_LICENSED, NWCC_RESERVED, connHandle)
                If connInfo.serverVersion.major > 3 Then
'        For DS server we also need DS context
                    retCode = NWDSCreateContextHandle(contextHandle)
'        We have to map ID to the DS object name if the server is 4.x or higher...
                    retCode = NWDSMapIDToName(contextHandle, connHandle, connInfo.userID, VarPtr(byteName(0)))
                    NWDSFreeContext (contextHandle)
                Else
'        ...or to bindery name if the server is 3.x
                    retCode = NWGetObjectName(connHandle, connInfo.userID, VarPtr(byteName(0)), objType)
                End If
                If retCode = 0 Then
                    Call ByteArrayToString(byteName, name)
                Else
                    name = ""
                End If
                retCode = NWCCCloseConn(connHandle)
                itmX.SubItems(1) = name
                itmX.SubItems(2) = Str(connInfo.connNum)
                Select Case connInfo.authenticationState
                    Case 0
                        name = "Not Authenticated"
                    Case 1
                        name = "Bindery"
                    Case 2
                        name = "Directory Services"
                    Case Else
                        name = " ??? (perplexed)"
                End Select
                itmX.SubItems(3) = name
                Call ByteArrayToString(connInfo.treeName, name)
                itmX.SubItems(4) = name
                networkAddress = ""
                Select Case tranAddr.type
                    Case 1
                        name = "IPX"
                        For i = 0 To 3
                            hexString = "0" + Hex(netAddr(i))
                            networkAddress = networkAddress + Mid(hexString, Len(hexString) - 1, 2)
                        Next i
                        networkAddress = networkAddress + ":"
                        For i = 4 To 9
                            hexString = "0" + Hex(netAddr(i))
                            networkAddress = networkAddress + Mid(hexString, Len(hexString) - 1, 2)
                        Next i
                        networkAddress = networkAddress + ":"
                        For i = 10 To 11
                            hexString = "0" + Hex(netAddr(i))
                            networkAddress = networkAddress + Mid(hexString, Len(hexString) - 1, 2)
                        Next i
                    Case 9
                        name = "IP"
                        For i = 2 To 5
                            networkAddress = networkAddress + Str(netAddr(i))
                            If i <> 5 Then
                                networkAddress = networkAddress + "."
                            End If
                        Next i
                        networkAddress = networkAddress + ":"
                        networkAddress = networkAddress + Str(netAddr(0) * 256 + netAddr(1))
                    Case Else
                        name = "???"
                        networkAddress = "???"
                End Select
                itmX.SubItems(5) = name
                itmX.SubItems(6) = networkAddress
            End If
        Else
            Exit Do
        End If
        DoEvents
    Loop
End Sub

Private Sub Command1_Click()
    ListView1.Visible = False
    GetConnections
    ListView1.Visible = True
End Sub

Private Sub Form_Load()
Dim retCode As Long
'  NWCallsInit is a must !
    retCode = NWCallsInit(0, 0)
    If retCode <> 0 Then
        Err.Raise retCode, "NWCallsInit", "NWCallsInit() - Cannot initialize !"
        Unload Me
    End If
' Let`s create ImageList to have nice outputs...
    ImageList1.ListImages.Clear
    ImageList1.ImageHeight = 16
    ImageList1.ImageWidth = 16
    Call ImageList1.ListImages.Add(, "Tree", LoadPicture(App.Path + "\Tree.ico"))
    Call ImageList1.ListImages.Add(, "Not Authenticated", LoadPicture(App.Path + "\NotAuth.ico"))
    Call ImageList1.ListImages.Add(, "Connected", LoadPicture(App.Path + "\Connect.ico"))
    GetConnections
End Sub
