VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00404040&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Digits Demo"
   ClientHeight    =   2190
   ClientLeft      =   1230
   ClientTop       =   1875
   ClientWidth     =   4395
   Height          =   2880
   Left            =   1170
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   2190
   ScaleWidth      =   4395
   Top             =   1245
   Width           =   4515
   Begin Timer Timer1 
      Interval        =   1000
      Left            =   3840
      Top             =   1680
   End
   Begin PictureClip clpPunctuation 
      Cols            =   8
      Location        =   "375,375,1200,3840"
   End
   Begin PictureClip clpDigits 
      Cols            =   11
      Location        =   "375,405,720,3840"
   End
   Begin Image imgClock 
      Height          =   495
      Index           =   0
      Left            =   120
      Top             =   120
      Width           =   495
   End
   Begin Image imgPunctuation 
      Height          =   405
      Index           =   0
      Left            =   3120
      Picture         =   DIGITS.FRX:0000
      Top             =   720
      Visible         =   0   'False
      Width           =   600
   End
   Begin Image imgPunctuation 
      Height          =   405
      Index           =   2
      Left            =   3120
      Picture         =   DIGITS.FRX:0296
      Top             =   1680
      Visible         =   0   'False
      Width           =   600
   End
   Begin Image imgPunctuation 
      Height          =   405
      Index           =   1
      Left            =   3120
      Picture         =   DIGITS.FRX:052C
      Top             =   1200
      Visible         =   0   'False
      Width           =   600
   End
   Begin Image imgDigits 
      Height          =   405
      Index           =   1
      Left            =   120
      Picture         =   DIGITS.FRX:07C2
      Top             =   1200
      Visible         =   0   'False
      Width           =   2970
   End
   Begin Image imgDigits 
      Height          =   405
      Index           =   0
      Left            =   120
      Picture         =   DIGITS.FRX:12C8
      Top             =   720
      Visible         =   0   'False
      Width           =   2970
   End
   Begin Image imgDigits 
      Height          =   405
      Index           =   2
      Left            =   120
      Picture         =   DIGITS.FRX:1DCE
      Top             =   1680
      Visible         =   0   'False
      Width           =   2970
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Begin Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu mnuOptions 
      Caption         =   "&Options"
      Begin Menu mnuOptColor 
         Caption         =   "&Red"
         Index           =   0
      End
      Begin Menu mnuOptColor 
         Caption         =   "&Green"
         Index           =   1
      End
      Begin Menu mnuOptColor 
         Caption         =   "&Blue"
         Index           =   2
      End
   End
End
Option Explicit
'
' Digits Demo, Version 1.00
' Copyright (c) 1994 SoftCircuits Programming
' Redistributed by Permission.
'
' This demo shows how you can create a digital display that appears
' like some sort of electronic LCD display and includes several
' bitmaps that can be used to create such displays.
'
' This program may be used and distributed freely on the condition
' that it is distributed in full and unchanged, and that no fee is
' charged for such use and/or distribution with the exception of
' reasonable media and/or shipping charges. You may also incorporate
' any and all portions of this program into your own programs and
' distribute such programs royalty free on the condition that such
' programs do not duplicate the overall functionality of this
' demonstration program.
'
' This program was created by:
'
'    SoftCircuits Programming
'    P.O. Box 16262
'    Irvine, CA 92713
'    CompuServe: 72134,263
'

Sub Form_Load ()
    Dim i As Integer, xFactor As Integer, yFactor As Integer

    'Load PicClip bitmaps so can know cell sizes
    Call SetColor(0, False)

    'Load image controls to hold digits
    imgClock(0) = clpDigits.GraphicCell(0)
    For i = 1 To 7
        Load imgClock(i)
        'Digit cells are a different size than colon (punctuation) cells
        If i = 2 Or i = 5 Then
            imgClock(i) = clpPunctuation.GraphicCell(0)
        Else
            imgClock(i) = clpDigits.GraphicCell(0)
        End If
        imgClock(i).Left = imgClock(i - 1).Left + imgClock(i - 1).Width
        imgClock(i).Visible = True
    Next i

    'Size window to fit time display
    xFactor = Width - ScaleWidth: yFactor = Height - ScaleHeight
    Move Left, Top, imgClock(7).Left + imgClock(7).Width + 120 + xFactor, imgClock(0).Height + 240 + yFactor

    'Show initial time display
    Call ShowCurrTime

End Sub

Sub Form_Resize ()
    'Since we display the time in the caption when the form is
    'minimized, restore caption if we are no longer minimized
    If WindowState <> 1 Then
        Caption = "Digits Demo"
    Else
        'If window has just been minimized, update time
        Call ShowCurrTime
    End If
End Sub

Sub mnuFileExit_Click ()
    'Unload form to terminate program
    Unload Me
End Sub

Sub mnuOptColor_Click (Index As Integer)
    'Update display color
    Call SetColor(Index, True)
End Sub

Sub SetColor (clr As Integer, updateTime As Integer)
    Static currColor As Integer
    Dim i As Integer

    'Set new color index
    currColor = clr

    'Load PicClip controls with bitmap for selected color
    clpDigits = imgDigits(currColor)
    clpPunctuation = imgPunctuation(currColor)

    'Check/uncheck menu items to indicate current color
    For i = 0 To 2
        mnuOptColor(i).Checked = (i = currColor)
    Next i

    'Update time display if requested
    If updateTime Then Call ShowCurrTime

End Sub

Sub ShowCurrTime ()
    Static showColon As Integer
    Dim i As Integer, buff As String, aChar As String

    'If window is minimized, show time in caption
    If WindowState = 1 Then
        Caption = Format$(Now, "h:mm:ss am/pm")
    Else
        'Get current time in buff
        buff = Format$(Now, "hh:mm:ss am/pm")

        'Hide first character if it is "0"
        aChar = Mid$(buff, 1, 1)
        If aChar = "0" Then
            imgClock(0) = clpDigits.GraphicCell(10)
        Else
            imgClock(0) = clpDigits.GraphicCell(Asc(aChar) - Asc("0"))
        End If

        'Display remaining digits
        For i = 2 To 8
            aChar = Mid$(buff, i, 1)
            If aChar = ":" Then
                If showColon Then
                    imgClock(i - 1) = clpPunctuation.GraphicCell(2)
                Else
                    imgClock(i - 1) = clpPunctuation.GraphicCell(3)
                End If
            Else
                imgClock(i - 1) = clpDigits.GraphicCell(Asc(aChar) - Asc("0"))
            End If
        Next i
    End If

    'Toggle display of colon
    showColon = Not showColon

End Sub

Sub Timer1_Timer ()
    'Update time display
    Call ShowCurrTime
End Sub

