Attribute VB_Name = "Module1"
Option Explicit


Public Const Title = "Dialer98-Pro"
Public Const VersionString = "[DIALER97 VERSION 2.2]"
Public Const Version20String = "[DIALER97 VERSION 2.0]"
Public Const ProviderFile = "Provider.DAT"
Public Const ProviderBakFile = "Provider.BAK"
Public Const DataFile = "Dialer97.DAT"
Public Const DataBakFile = "Dialer97.BAK"
Public Const UpdateFile = "Update.DAT"
Public Const UpdateTitle = "Provider-Update"
Public Const UpdateSig = "Dialer98 Pro Provider Update"
'-> TRUE one
Public Const UpdateUrl = "http://www.zdnet.de/download/service/ttarif/ttarif.csv"

'-> DEBUG!
'Public Const UpdateUrl = "http://localhost/wsdocs/ttarif.csv"
'Public Const UpdateUrl = "HTTP://perso.wanadoo.fr/wolfgang.wirth/ttarif.txt"

Public Const NamListPic = 1
Public Const OptionPic = 5
Public Const OptionsTab = 5

Public Const siVorwahl = 1
Public Const siTag = 2
Public Const siAb = 3
Public Const siBis = 4
Public Const siWeite = 5

Public UpdateFailed As Boolean

Public RcvString As String
Public DummyStr As String
Public DummyInt As Integer

Public sep As String

'### TimeSlider zeigt seltsames verhalten ... ???
'### daher von bis ueber dier vars bergeben
Public TimeSliderVon As Integer
Public TimeSliderBis As Integer

Public PicActiv As Integer

Public ThisIsANewEntry As Boolean
Public ExternalWindowActive As Boolean
Public CurrTelcoEntry As Long

Public CommPortNummer As Integer
Public PulsWahl As Integer
Public AmtPrefix As String
Public AuslandPrefix As String
Public OrtsKennZahl As String
Public LandesKennZahl As String
Public ZusModemBefehleVorDerWahl As String
Public UebergabeTelNr As String
Public MacheUebergabe As Integer
Public IsV20 As Boolean

Public Const cDistanzNah = 1
Public Const cDistanzFern = 2
Public Const cDistanzAusland = 3
Public Const cNFA = "NFA" ' Nah Fern Ausland

Public Const cTagWerktags = "Mo-Fr"
Public Const cTagWochenende = "Sa-So"
Public Const cTagImmer = "Immer"

Public Const cLeftClick = 1
Public Const cRightClick = 2
Public Const cLeftDblClick = &H101
Public Const cRightDblClick = &H102

'Benutzerdef. Variable zum bermitteln der Shell_NotifyIcon-Info
Public Type NOTIFYICONDATA
   cbSize As Long
   hWnd As Long
   uId As Long
   uFlags As Long
   uCallBackMessage As Long
   hIcon As Long
   szTip As String * 64
End Type

'Die Shell_NotifyIcon-Kommandos
Public Const NIM_ADD = &H0
Public Const NIM_MODIFY = &H1
Public Const NIM_DELETE = &H2

'Die Shell_NotifyIcon-Flags
Public Const NIF_MESSAGE = &H1
Public Const NIF_ICON = &H2
Public Const NIF_TIP = &H4

'Das ist die Windows-Message, die fr das Mchtegern-Callback
'benutzt wird.
Public Const WM_MOUSEMOVE = &H200

'Div. Mausklicks
Public Const WM_LBUTTONDBLCLK = &H203   'Double-click
Public Const WM_LBUTTONDOWN = &H201     'Button down
Public Const WM_RBUTTONDBLCLK = &H206   'Double-click
Public Const WM_RBUTTONDOWN = &H204     'Button down

'Die Shell_NotifyIcon-Funktion
Public Declare Function Shell_NotifyIconA Lib "shell32" (ByVal dwMessage As Long, pnid As NOTIFYICONDATA) As Boolean

'Hilfsvariablen um den SingleKlick auswerten zu knnen (wird nicht vom System geliefert!)
Public NiKeyEventDblClickFlag As Integer
Public NiKeyEventButtonID As Integer

Sub ShowInfo()
    ww_info Title, "Die professionelle Wahlhilfe fr Windows 95/NT" + vbCr + _
                          "mit automatischer Provider-Auswahl"
End Sub

Sub ww_info(t As String, s As String)
    MsgBox s + vbCr + vbCr + " 1996 - 1998 by Wolfgang Wirth" + vbCr + vbCr + "'Verbesserungsvorschlge und konstruktive" + vbCr + "Kritik sind immer willkommen ...'" + vbCr + vbCr + "E-Mail: Wolfgang.Wirth@Wanadoo.fr", 64, t
End Sub

Sub VonBisStr2Num(sVonBis As String, iVon As Integer, iBis As Integer)
    '### aufbau des str. "VVh_-_BBh"
    iVon = Val(Left(sVonBis, 2))
    iBis = Val(Mid(sVonBis, 7, 2))
End Sub

Sub VonBisNum2Str(iVon As Integer, iBis As Integer, sVonBis As String)
    '### aufbau des str. "VVh_-_BBh"
    sVonBis = Right(Format(100 + iVon), 2) + "h - " + Right(Format(100 + iBis), 2) + "h"
End Sub

Sub WeiteNum2Str(iWeite As Integer, sWeite As String)
Dim i As Integer
    sWeite = ""
    For i = 0 To 2
        If 2 ^ i And iWeite Then sWeite = sWeite + Mid(cNFA, i + 1, 1)
    Next
End Sub

Sub WeiteStr2Num(sWeite As String, iWeite As Integer)
Dim i As Integer
    iWeite = 0
    For i = 0 To 2
        If InStr(sWeite, Mid(cNFA, i + 1, 1)) Then iWeite = iWeite Or 2 ^ i
    Next
End Sub

Function SelectedItemIndex(Lv As ListView) As Long
Dim i As Long
        For i = 1 To Lv.ListItems.Count
            If Lv.ListItems(i).Selected Then
                SelectedItemIndex = i
                Exit For
            End If
        Next '### ist 0, falls nix sel. ist
End Function

Sub AddToTelcoList(sAnbieter As String, sVorwahl As String, iWerktags As Integer, iWochenende As Integer, iAb As Integer, iBis As Integer, iNah As Integer, iFern As Integer, iAusland As Integer)
Dim i As Long
Dim s As String
    With Form1.TelcoList
        .Sorted = False
        i = .ListItems.Count + 1
        i = 1 '*'*'*'*
        .ListItems.Add i, , Trim(sAnbieter)
        .ListItems(i).SubItems(siVorwahl) = Trim(sVorwahl)
        Select Case iWerktags Or 2 * iWochenende
            Case 1
                s = cTagWerktags
            Case 2
                s = cTagWochenende
            Case 3
                s = cTagImmer
        End Select
        .ListItems(i).SubItems(siTag) = s
        .ListItems(i).SubItems(siAb) = Right$("0" & iAb & "h", 3)
        .ListItems(i).SubItems(siBis) = Right$("0" & iBis & "h", 3)
        s = ""
        If iNah Then s = s + "N"
        If iFern Then s = s + "F"
        If iAusland Then s = s + "A"
        .ListItems(i).SubItems(siWeite) = s
        .Sorted = True
    End With
End Sub

Function BestProvider(Wochentag As Integer, Stunde As Integer, Distanz As Integer) As String
Dim i As Long
Dim s As String
    Debug.Print "BestProvider (Wochentag,Stunde,Distanz): "; Wochentag; Stunde; Distanz;
    With Form1.TelcoList
        For i = 1 To .ListItems.Count
            s = .ListItems(i).SubItems(siTag)
            If ((s = cTagImmer) Or ((s = cTagWerktags) And (Wochentag <= 5)) Or ((s = cTagWochenende) And (Wochentag >= 6))) And _
               ((Stunde >= Val(.ListItems(i).SubItems(siAb))) And (Stunde < Val(.ListItems(i).SubItems(siBis)))) And _
               (InStr(.ListItems(i).SubItems(siWeite), Mid$(cNFA, Distanz, 1)) <> 0) Then '### treffer
                    s = .ListItems(i).SubItems(siVorwahl)
                    Debug.Print " --> "; s:
                    BestProvider = s
                    Exit For
            End If
        Next
    End With
    Debug.Print
End Function

Public Sub SaveProviderFile()
Dim s As String
Dim d As String
Dim f As Integer
Dim i As Integer

If Dir$(ProviderBakFile) <> "" Then Kill ProviderBakFile
If Dir$(ProviderFile) <> "" Then Name ProviderFile As ProviderBakFile
f = FreeFile
Open ProviderFile For Output As f
For i = 1 To Form1.TelcoList.ListItems.Count
    With Form1.TelcoList.ListItems(i)
        s = .SubItems(siTag)
        d = .SubItems(siWeite)
        Write #f, .Text, .SubItems(siVorwahl), _
            -(s = cTagImmer) Or -(s = cTagWerktags), -(s = cTagImmer) Or -(s = cTagWochenende), _
            Val(.SubItems(siAb)), Val(.SubItems(siBis)), _
            -(InStr(d, "N") <> 0), -(InStr(d, "F") <> 0), -(InStr(d, "A") <> 0)
    End With
Next
Close f
End Sub

Public Sub LoadProviderFile()
Dim f As Integer
Dim sAnbieter As String
Dim sVorwahl As String
Dim iWerktags As Integer
Dim iWochenende As Integer
Dim iAb As Integer
Dim iBis As Integer
Dim iNah As Integer
Dim iFern As Integer
Dim iAusland As Integer

f = FreeFile
Open ProviderFile For Input As f
Do While Not EOF(f)
    Input #f, sAnbieter, sVorwahl, iWerktags, iWochenende, iAb, iBis, iNah, iFern, iAusland
    AddToTelcoList sAnbieter, sVorwahl, iWerktags, iWochenende, iAb, iBis, iNah, iFern, iAusland
Loop
Close f
End Sub

Public Sub LoadDataFile()

Dim MyFontsize As Integer
Dim i As Integer
Dim ZeroFlagDigit As Integer
Dim NameStr As String
Dim TelefonNrStr As String

Input #1, CommPortNummer, PulsWahl, DummyInt, AmtPrefix, _
              DummyInt, AuslandPrefix, LandesKennZahl, _
              MyFontsize, ZusModemBefehleVorDerWahl, _
              UebergabeTelNr, MacheUebergabe
    
'### LandesKennZahl und Ortskennzahl werden im gl. string gehalten getrennt durch ein "|"
LandesKennZahl = Trim(LandesKennZahl)
If (LandesKennZahl = "0") Or (LandesKennZahl = "") Or (LandesKennZahl = "|") Then
    LandesKennZahl = "49"
End If
i = InStr(LandesKennZahl, "|")
If i Then
    OrtsKennZahl = Trim(Mid(LandesKennZahl, i + 1))
    LandesKennZahl = Trim(Left(LandesKennZahl, i - 1))
End If

For i = 1 To 4
    Form1.NamList(i).Font.Size = MyFontsize
    Input #1, NameStr
    Form1.TabStrip1.Tabs(i).Caption = NameStr
Next

Do While Not EOF(1)
    Input #1, i
    If i = 0 Then Exit Do
    Input #1, NameStr, TelefonNrStr
    If IsV20 Then
        ZeroFlagDigit = 1
    Else
        Input #1, ZeroFlagDigit     '<-bei nationaler Anwahl eine 0 voranstellen
        ZeroFlagDigit = ZeroFlagDigit And 1
    End If
    Form1.NamList(i).AddItem Trim(NameStr) + sep + Trim(TelefonNrStr) + "~" + Chr$(48 + ZeroFlagDigit)
Loop
    
End Sub

Public Sub SaveDataFile()
Dim s As String
Dim f As Integer
Dim i As Integer
Dim j As Integer
Dim NamensStr As String
Dim TelefonNrStr As String

        If Dir$(DataBakFile) <> "" Then Kill DataBakFile
        If Dir$(DataFile) <> "" Then Name DataFile As DataBakFile
        
        f = FreeFile
        Open DataFile For Output As f
        ExchangeQuotes AmtPrefix
        ExchangeQuotes AuslandPrefix
        ExchangeQuotes ZusModemBefehleVorDerWahl
        ExchangeQuotes UebergabeTelNr
        Print #f, VersionString
        Write #f, CommPortNummer, PulsWahl, DummyInt, AmtPrefix, _
                        DummyInt, AuslandPrefix, LandesKennZahl + "|" + OrtsKennZahl, _
                        Form1.FntSmpl.Font.Size, ZusModemBefehleVorDerWahl, _
                        UebergabeTelNr, MacheUebergabe
        
        For i = 1 To 4
            NamensStr = Form1.TabStrip1.Tabs(i).Caption
            ExchangeQuotes NamensStr
            If i = 4 Then
                Write #f, NamensStr
            Else
                Write #f, NamensStr;
            End If
        Next
        For j = 1 To 4
            For i = 0 To Form1.NamList(j).ListCount - 1
                s = Form1.NamList(j).List(i)
                NamensStr = Trim(Teilnehmername(s))
                TelefonNrStr = Trim(TelefonNummer(s))
                ExchangeQuotes NamensStr
                ExchangeQuotes TelefonNrStr
                Write #f, j, NamensStr, TelefonNrStr, ZeroFlag(s)
            Next
        Next
        Close f
End Sub

Public Function TelefonNummerMitZeroFlag(s As String) As String
    TelefonNummerMitZeroFlag = Mid$(s, InStr(s, sep) + Len(sep))
End Function

Public Function TelefonNummer(s As String) As String
Dim tmps As String
    tmps = TelefonNummerMitZeroFlag(s)
    TelefonNummer = Left$(tmps, Len(tmps) - 2)
End Function

Public Sub ExchangeQuotes(s As String)
Dim i As Long
    For i = 1 To Len(s)
        If Mid$(s, i, 1) = Chr$(34) Then Mid$(s, i, 1) = "'"
    Next
End Sub

Public Function Teilnehmername(s As String) As String
    Teilnehmername = Left$(s, InStr(s, sep) - 1)
End Function

Public Function ZeroFlag(s As String) As Integer
    ZeroFlag = Val(Right$(TelefonNummerMitZeroFlag(s), 1))
End Function

Public Sub EditNameEntry(nam As String, tel As String, i As Integer)
    With Form2
        .Text1(0).Text = nam
        .Text1(1).Text = tel
        .ZeroChk.Value = i
        ThisIsANewEntry = (nam = "") And (tel = "")
        ExternalWindowActive = True
        .Show 1
        ExternalWindowActive = False
    End With
End Sub

Public Sub EditProviderEntry(nam As String, num As String, TageIdx As Integer, von As Integer, bis As Integer, ivN As Integer, ivF As Integer, ivA As Integer)
    With Form3
        TimeSliderVon = von
        TimeSliderBis = bis
        .Text1(0).Text = nam
        .Text1(1).Text = num
        If TageIdx Then
            .OptTage(TageIdx).Value = True
        Else
            .OptTage(1).Value = True
        End If
        .ChkWeite(1).Value = ivN
        .ChkWeite(2).Value = ivF
        .ChkWeite(3).Value = ivA
        ThisIsANewEntry = (nam = "") And (num = "")
        ExternalWindowActive = True
        .Show 1
        ExternalWindowActive = False
    End With
End Sub

Public Sub InitMyApp()

Dim s As String
Dim t As String
Dim i As Long
Dim DoUpdate As Boolean

sep = String$(150, 32) + Chr$(1)

PicActiv = NamListPic
Form1.Picture1(PicActiv).ZOrder 0

If Dir$(DataFile) = "" Then
    MacheUebergabe = 0
    CommPortNummer = 1
    PulsWahl = 1
    AmtPrefix = ""
    AuslandPrefix = "00"
    LandesKennZahl = "49"
    OrtsKennZahl = ""
    SaveDataFile
    MsgBox "Es wurde eine neue Telefon- und Einstellungendatei angelegt." + vbCr + "Sie sollten daher die Programmeinstellungen jetzt berprfen!", 64, Title
    ShowOptionsTab
Else
    Open DataFile For Input As #1
    Line Input #1, s
    s = Trim(s)
    Select Case s
        Case VersionString
            IsV20 = False
            LoadDataFile
        Case Version20String
            IsV20 = True
            LoadDataFile
            DoUpdate = True
        Case Else
            MsgBox "Die Telefonliste ist nicht kompatibel und" + vbCr + _
                "kann daher nicht eingelesen werden." + vbCr + vbCr + _
                "Das Programm wird abgebrochen", vbCritical, Title
            End
        End Select
    Close #1
    If DoUpdate Then SaveDataFile
End If

If Dir$(ProviderFile) <> "" Then
    LoadProviderFile
End If

'AddToTelcoList "Arcor", "01070", 0, 1, 12, 18, 1, 0, 0
'AddToTelcoList "Arcor", "01070", 1, 0, 22, 24, 0, 1, 0
'AddToTelcoList "Arcor", "01070", 1, 0, 0, 6, 0, 1, 0
'AddToTelcoList "MobilCom", "01019", 1, 1, 6, 22, 0, 0, 1
'AddToTelcoList "MobilCom", "01019", 1, 0, 9, 12, 1, 1, 1

End Sub

Public Sub ShowOptionsTab()
    Form1.TabStrip1.Tabs(OptionsTab).Selected = True
End Sub

Public Sub Status(s As String)
    Form1.StatusBar1.SimpleText = s
End Sub


Public Sub Dial()

Dim TelNr As String
Dim UebergabeStr As String
Dim DialPrefix As String
Dim CompleteDialString As String
Dim DialErr As Boolean
Dim CurrNamListEntry As String
Dim DialType As String
Dim i As Integer
Dim AnrufDistanz As Integer
Dim s As String

    'kleine Zugriffshilfe
    CurrNamListEntry = Form1.NamList(Form1.TabStrip1.SelectedItem.Index).List(Form1.NamList(Form1.TabStrip1.SelectedItem.Index).ListIndex)
    TelNr = TelefonNummer(CurrNamListEntry)
    
    'entscheide ob puls oder ton wahl
    If PulsWahl Then DialType = "P" Else DialType = "T"
    
    'DISTANZ des Anrufs bestimmen
    i = Len(LandesKennZahl)
    If i And (Left$(TelNr, i) = LandesKennZahl) Then
        '>>nationaler anruf -> nah oder fern=?
        TelNr = LTrim$(Mid$(TelNr, i + 1))
        i = Len(OrtsKennZahl)
        If i And (Left$(TelNr, i) = OrtsKennZahl) Then
            '>>nahbereich
            TelNr = LTrim$(Mid$(TelNr, i + 1))
            AnrufDistanz = cDistanzNah
        Else
            '>>fernbereich -> bei nationalem Anruf 0 voranstellen?
            If ZeroFlag(CurrNamListEntry) Then TelNr = "0" + TelNr
            AnrufDistanz = cDistanzFern
        End If
    Else
        'INTERnationaler anruf....
        DialPrefix = AuslandPrefix
        'TelNr selbst bleibt
        AnrufDistanz = cDistanzAusland
    End If
    
    'Sind wird in Deutschland? Ja, dann Provider auswhlen ->
    If LandesKennZahl = 49 Then
        DialPrefix = BestProvider(WeekDay(Date, vbMonday), Hour(Time), AnrufDistanz) + DialPrefix
    End If
    
    ' weiterleiten? -- aber nur bei TONWAHL  ((hier stand vormals ---;D!,--- ))
    If MacheUebergabe Then If PulsWahl = 0 Then UebergabeStr = ";DP1T" + UebergabeTelNr
    CompleteDialString = "AT" + ZusModemBefehleVorDerWahl + "D" + DialType + AmtPrefix + DialPrefix + TelNr + UebergabeStr + ";H0" + vbCr
    Debug.Print "CompleteDialString="; CompleteDialString
    'jetzt nummer whlen
    On Error GoTo SendComErrHnd
    RcvString = ""
    If Form1.Comm.PortOpen Then Form1.Comm.PortOpen = False
    Form1.Comm.CommPort = CommPortNummer
    Form1.Comm.Settings = "2400,n,8,1"
    Form1.Comm.InputLen = 0
    Form1.Comm.Handshaking = 2
    Form1.Comm.PortOpen = True
    Form1.Comm.Output = CompleteDialString
    
    Form4.Label1(0) = Teilnehmername(CurrNamListEntry)
    s = TelNr
    If AnrufDistanz = cDistanzAusland Then s = "+" + s
    Form4.Label1(1) = s
    ExternalWindowActive = True
    Form4.Show 1
    ExternalWindowActive = False
    
SendExit:
    On Error GoTo 0
    If DialErr Then
        MsgBox "Der angegebene Anschlu COM" + Format$(CommPortNummer) + " ist nicht verfgbar.", 16, Title
        ShowOptionsTab
    End If
    Exit Sub

SendComErrHnd:
    DialErr = True
    Resume SendExit

End Sub

Public Sub DeleteCurrentNameEntry()
    Form1.NamList(Form1.TabStrip1.SelectedItem.Index).RemoveItem Form1.NamList(Form1.TabStrip1.SelectedItem.Index).ListIndex
End Sub

Public Sub DeleteCurrentProviderEntry()
    Form1.TelcoList.Sorted = False
    Form1.TelcoList.ListItems.Remove CurrTelcoEntry
    Form1.TelcoList.Sorted = True
End Sub

Public Sub DeleteAllProviderEntries()
Dim i As Long
    Form1.TelcoList.Sorted = False
    For i = 1 To Form1.TelcoList.ListItems.Count
        Form1.TelcoList.ListItems.Remove 1
    Next
    Form1.TelcoList.Sorted = True
End Sub

Public Sub ActivateTelcoPum()
    With Form1
        CurrTelcoEntry = SelectedItemIndex(.TelcoList)
        .pum3(2).Enabled = CurrTelcoEntry <> 0
        .pum3(3).Enabled = CurrTelcoEntry <> 0
        .PopupMenu .pummain3, , , , .pum3(5)
    End With
End Sub

Sub DownloadUpdateFile()
Dim sAnbieter As String
Dim sVorwahl As String
Dim sWerktags As String
Dim sWochenende As String
Dim iAb As Integer
Dim iBis As Integer
Dim sNah As String
Dim sFern As String
Dim sAusland As String
Dim s As String
Dim i As Long
Dim f As Long

    Debug.Print "DownloadUpdateFile()"
    Form1.Btn(1).Enabled = False
    Form1.Inet1.AccessType = icDirect
    On Local Error GoTo DlErr
    s = Form1.Inet1.OpenURL(UpdateUrl, icString)
    On Error GoTo 0
    If Not UpdateFailed Then
        For i = 1 To Len(s)
            If Mid$(s, i, 1) = ";" Then Mid$(s, i, 1) = ","
            If Mid$(s, i, 1) = Chr$(34) Then s = Left$(s, i - 1) & Mid$(s, i + 1)
        Next
        
        If Left$(s, Len(UpdateSig)) = UpdateSig Then  '### sig testen
        
            f = FreeFile
            Open UpdateFile For Output As f
            Print #f, s;
            Close f
            MsgBox "bertragung beendet - Sie knnen die Verbindung zum Internet jetzt beenden", vbInformation, UpdateTitle
            '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            ' NEUE DATEN EINFGEN
            '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            If vbYes = MsgBox("Mchten Sie Ihre alten Provider-Daten lschen?", vbYesNo Or vbDefaultButton2 Or vbQuestion, UpdateTitle) Then DeleteAllProviderEntries
            f = FreeFile
            Open UpdateFile For Input As f
            Line Input #f, s    ' = SIgnature
            Line Input #f, s    ' = TableHeads
            
            On Error Resume Next    'Eventuelle Fehler beim Einlesen ber das Dateiende hinaus brutal unterbinden
            Err = 0
            Do While Not EOF(f) And Err = 0
                Input #f, sAnbieter, sVorwahl, sWerktags, sWochenende, iAb, iBis, sNah, sFern, sAusland
                Line Input #f, s 'den Rest der Zeile lesen
                If Err = 0 Then
                    AddToTelcoList sAnbieter, sVorwahl, Sgn(Len(sWerktags)), Sgn(Len(sWochenende)), iAb, iBis, Sgn(Len(sNah)), Sgn(Len(sFern)), Sgn(Len(sAusland))
                End If
            Loop
            Close f
            SaveProviderFile
            '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        Else '## sig nicht da?
            MsgBox "Es liegt z.Z. keine gltiges Provider-Update vor - versuchen Sie es bitte spter noch einmal." & vbCr & "Sie knnen die Verbindung zum Internet jetzt beenden.", vbExclamation, UpdateTitle
        End If
    End If
    Form1.Btn(1).Enabled = True
Exit Sub

'########
DlErr:
    UpdateFailed = True
    MsgBox "Es gab folgerndes Problem:" + vbCr + Err.Description & " (" & Err.Number & ")", vbCritical, UpdateTitle
    Resume Next
End Sub
