VERSION 4.00
Begin VB.Form Form1 
   Caption         =   "ChangRez sample by Matt Hart - mhart@taascforce.com"
   ClientHeight    =   4800
   ClientLeft      =   1140
   ClientTop       =   1515
   ClientWidth     =   6825
   Height          =   5205
   Left            =   1080
   LinkTopic       =   "Form1"
   ScaleHeight     =   4800
   ScaleWidth      =   6825
   Top             =   1170
   Width           =   6945
   Begin VB.CommandButton Command1 
      Caption         =   "Switch!"
      Height          =   495
      Left            =   4680
      TabIndex        =   2
      Top             =   1740
      Width           =   1695
   End
   Begin VB.ListBox List1 
      Height          =   3960
      Left            =   180
      TabIndex        =   1
      Top             =   600
      Width           =   4035
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "Available Resolutions"
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Top             =   180
      Width           =   3975
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False


Option Explicit

' ChangRez sample by Matt Hart - mhart@taascforce.com
' http://www.webczar.com/defcon/mh/vbhelp.html
' http://www.webczar.com/defcon/mh
'
' How to change video resolution in Windows 95.
' The WinSDK API declarations for VB does NOT include
' this useful procedure, nor does it include some
' of the needed constants.  I had to guess at the API
' declaration (well, an educated guess ;-), and go to
' my Visual C include files to find the DM_ constants.

Const CCHDEVICENAME = 32
Const CCHFORMNAME = 32

Private Type DEVMODE
    dmDeviceName As String * CCHDEVICENAME
    dmSpecVersion As Integer
    dmDriverVersion As Integer
    dmSize As Integer
    dmDriverExtra As Integer
    dmFields As Long
    dmOrientation As Integer
    dmPaperSize As Integer
    dmPaperLength As Integer
    dmPaperWidth As Integer
    dmScale As Integer
    dmCopies As Integer
    dmDefaultSource As Integer
    dmPrintQuality As Integer
    dmColor As Integer
    dmDuplex As Integer
    dmYResolution As Integer
    dmTTOption As Integer
    dmCollate As Integer
    dmFormName As String * CCHFORMNAME
    dmUnusedPadding As Integer
    dmBitsPerPel As Integer
    dmPelsWidth As Long
    dmPelsHeight As Long
    dmDisplayFlags As Long
    dmDisplayFrequency As Long
End Type

Const DM_BITSPERPEL = &H40000
Const DM_PELSWIDTH = &H80000
Const DM_PELSHEIGHT = &H100000

Private Declare Function ChangeDisplaySettings Lib "user32" Alias "ChangeDisplaySettingsA" (lpInitData As DEVMODE, ByVal dwFlags As Long) As Long
Private Declare Function EnumDisplaySettings Lib "user32" Alias "EnumDisplaySettingsA" (ByVal lpszDeviceName As Long, ByVal iModeNum As Long, lpDevMode As DEVMODE) As Long
Private Declare Function ExitWindowsEx Lib "user32" (ByVal uFlags As Long, ByVal dwReserved As Long) As Long

' /* Flags for ChangeDisplaySettings */
Const CDS_UPDATEREGISTRY = &H1
Const CDS_TEST = &H2
Const CDS_FULLSCREEN = &H4
Const CDS_GLOBAL = &H8
Const CDS_SET_PRIMARY = &H10
Const CDS_RESET = &H40000000
Const CDS_SETRECT = &H20000000
Const CDS_NORESET = &H10000000

' /* Return values for ChangeDisplaySettings */
Const DISP_CHANGE_SUCCESSFUL = 0
Const DISP_CHANGE_RESTART = 1
Const DISP_CHANGE_FAILED = -1
Const DISP_CHANGE_BADMODE = -2
Const DISP_CHANGE_NOTUPDATED = -3
Const DISP_CHANGE_BADFLAGS = -4
Const DISP_CHANGE_BADPARAM = -5

Const EWX_LOGOFF = 0
Const EWX_SHUTDOWN = 1
Const EWX_REBOOT = 2
Const EWX_FORCE = 4

Dim D() As DEVMODE, lNumModes As Long

Private Sub Command1_Click()
    Dim l As Long, Flags As Long, x As Long
    x = List1.ListIndex + 1
    D(x).dmFields = DM_BITSPERPEL Or DM_PELSWIDTH Or DM_PELSHEIGHT
    Flags = CDS_UPDATEREGISTRY
    l = ChangeDisplaySettings(D(x), Flags)
    Select Case l
        Case DISP_CHANGE_RESTART
            l = MsgBox("You must reboot for the change to take effect.", vbOKCancel)
            If l = vbOK Then
                Flags = 0
                l = ExitWindowsEx(EWX_REBOOT, Flags)
            End If
        Case DISP_CHANGE_SUCCESSFUL
        Case Else
            MsgBox "Error changing resolution!"
    End Select
End Sub

Private Sub Form_Load()
    Dim l As Long, lMaxModes As Long
    lMaxModes = 8
    ReDim D(0 To lMaxModes) As DEVMODE
    lNumModes = 0
    l = EnumDisplaySettings(0, lNumModes, D(lNumModes))
    Do
        lNumModes = lNumModes + 1
        If lNumModes > lMaxModes Then
            lMaxModes = lMaxModes + 8
            ReDim Preserve D(0 To lMaxModes) As DEVMODE
        End If
        l = EnumDisplaySettings(0, lNumModes, D(lNumModes))
        If l = 0 Then Exit Do
        List1.AddItem D(lNumModes).dmPelsWidth & "x" & D(lNumModes).dmPelsHeight & "x" & D(lNumModes).dmBitsPerPel
    Loop
    lNumModes = lNumModes - 1
End Sub
