VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Begin VB.Form frmTreeview 
   Caption         =   "Datenbank-gebundene Hierarchieansicht"
   ClientHeight    =   7335
   ClientLeft      =   735
   ClientTop       =   2640
   ClientWidth     =   9660
   LinkTopic       =   "Form1"
   ScaleHeight     =   7335
   ScaleWidth      =   9660
   Begin VB.ComboBox Combo1 
      Height          =   315
      Left            =   6960
      TabIndex        =   4
      Text            =   "Combo1"
      Top             =   0
      Width           =   2415
   End
   Begin VB.CommandButton cmdLoad 
      Caption         =   "Laden"
      Height          =   270
      Left            =   2190
      TabIndex        =   1
      Top             =   4935
      Visible         =   0   'False
      Width           =   1050
   End
   Begin ComctlLib.TabStrip TabStrip1 
      Height          =   30
      Left            =   1305
      TabIndex        =   6
      Top             =   5145
      Width           =   30
      _ExtentX        =   53
      _ExtentY        =   53
      _Version        =   327682
      BeginProperty Tabs {0713E432-850A-101B-AFC0-4210102A8DA7} 
         NumTabs         =   1
         BeginProperty Tab1 {0713F341-850A-101B-AFC0-4210102A8DA7} 
            Caption         =   ""
            Key             =   ""
            Object.Tag             =   ""
            ImageVarType    =   2
         EndProperty
      EndProperty
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ComctlLib.StatusBar sbrDB 
      Align           =   2  'Unten ausrichten
      Height          =   255
      Left            =   0
      TabIndex        =   5
      Top             =   7080
      Width           =   9660
      _ExtentX        =   17039
      _ExtentY        =   450
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   1
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            TextSave        =   ""
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
      EndProperty
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ComctlLib.ProgressBar prgLoad 
      Height          =   210
      Left            =   255
      TabIndex        =   3
      Top             =   375
      Visible         =   0   'False
      Width           =   9090
      _ExtentX        =   16034
      _ExtentY        =   370
      _Version        =   327682
      Appearance      =   1
   End
   Begin ComctlLib.ListView lvwDB 
      Height          =   4215
      Left            =   3480
      TabIndex        =   2
      Top             =   615
      Width           =   5880
      _ExtentX        =   10372
      _ExtentY        =   7435
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   327682
      Icons           =   "imlIcons"
      SmallIcons      =   "imlSmallIcons"
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      Appearance      =   1
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      NumItems        =   0
   End
   Begin MSComDlg.CommonDialog dlgDialog 
      Left            =   1605
      Top             =   4830
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      FilterIndex     =   474
      FontSize        =   6,31099e-38
   End
   Begin ComctlLib.TreeView tvwDB 
      Height          =   4215
      Left            =   255
      TabIndex        =   0
      Top             =   615
      Width           =   3120
      _ExtentX        =   5503
      _ExtentY        =   7435
      _Version        =   327682
      LineStyle       =   1
      Style           =   7
      ImageList       =   "imlSmallIcons"
      Appearance      =   1
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Label Label1 
      Caption         =   "Label1"
      Height          =   255
      Left            =   1200
      TabIndex        =   8
      Top             =   6600
      Width           =   2055
   End
   Begin VB.Label lblI 
      Caption         =   "Klicken Sie im Menu ""Datei"" auf ""Laden"", um Biblio.mdb zu laden"
      Height          =   255
      Left            =   2040
      TabIndex        =   7
      Top             =   0
      Width           =   4815
   End
   Begin ComctlLib.ImageList imlIcons 
      Left            =   645
      Top             =   4800
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   32
      ImageHeight     =   32
      MaskColor       =   12632256
      _Version        =   327682
      BeginProperty Images {0713E8C2-850A-101B-AFC0-4210102A8DA7} 
         NumListImages   =   1
         BeginProperty ListImage1 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "treeview.frx":0000
            Key             =   "Buch"
         EndProperty
      EndProperty
   End
   Begin ComctlLib.ImageList imlSmallIcons 
      Left            =   45
      Top             =   4815
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   13
      ImageHeight     =   13
      MaskColor       =   12632256
      _Version        =   327682
      BeginProperty Images {0713E8C2-850A-101B-AFC0-4210102A8DA7} 
         NumListImages   =   6
         BeginProperty ListImage1 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "treeview.frx":031A
            Key             =   "geschlossen"
         EndProperty
         BeginProperty ListImage2 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "treeview.frx":083C
            Key             =   "Zylinder"
         EndProperty
         BeginProperty ListImage3 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "treeview.frx":0D5E
            Key             =   "Blatt"
         EndProperty
         BeginProperty ListImage4 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "treeview.frx":1280
            Key             =   "geffnet"
         EndProperty
         BeginProperty ListImage5 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "treeview.frx":17A2
            Key             =   "kleinesBuch"
         EndProperty
         BeginProperty ListImage6 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "treeview.frx":1E04
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.Menu mnuFile 
      Caption         =   "Datei"
      Begin VB.Menu mnuLoad 
         Caption         =   "Laden"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "Beenden"
      End
   End
End
Attribute VB_Name = "frmTreeview"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private mDbBiblio As Database ' Datenbankvariable auf Modulebene.
Private mNode As Node ' Knotenvariable auf Modulebene.
Private mWksBiblio As Workspace ' WorkSpace-Variable auf Modulebene.
Private mItem As ListItem ' ListItem-Variable auf Modulebene.
Private EventFlag As Integer ' Signalisiert, welches Ereignis eingetreten ist.
Private mCurrentIndex As Integer ' Flag zum Sicherstellen, da nicht schon auf Knoten geklickt wurde.
Private mStatusBarStyle As Integer ' Schaltet den Stil der Statusleiste um.

Const PUBLISHER = 1 ' Fr EventFlag. Signalisiert Objekte der Spaltenberschrift "Publisher".
Const TITLE = 2 ' Fr EventFlag. Signalisiert Titel in der Listenansicht.
Private Sub cmdLoad_Click()
    ' Deklarieren der Variablen fr Datenzugriffsobjekte.
    Dim rsPublishers As Recordset
    Dim rsTitles As Recordset
    
    ' Variable fr den Index des
    ' aktuellen Knotens.
    Dim intIndex
    
    ' Festlegen der Datenbank auf die
    ' Datenbank BIBLIO.MDB. Festlegen
    ' des Recordsets auf die Tabelle
    ' "Publishers".
    Set rsPublishers = mDbBiblio. _
    OpenRecordset("Publishers", dbOpenDynaset)
    
    ' Anzeigen der Fortschrittsleiste.
    prgLoad.Visible = True
    ' Festlegen des Stils der Statusleiste
    ' auf "einfach".
    sbrDB.Style = sbrSimple
    ' Hinzufgen eines Listenelements,
    ' solange Datensatz nicht der
    ' letzte Datensatz ist. Verwenden
    ' des Felds "Name" als Text
    ' des Listenelement-Objekts.
    Do Until rsPublishers.EOF
        
        prgLoad.Value = rsPublishers.PercentPosition
        ' Hinzufgen eines Knotens zur
        ' Hierarchieansicht, und Festlegen
        ' seiner Eigenschaften.
        Set mNode = tvwDB.Nodes.Add(1, tvwChild, rsPublishers!PubID & " ID", CStr(rsPublishers!Name), "geschlossen")
        ' Bezeichnet die Tabelle.
        mNode.Tag = "Verlag"
        ' Festlegen der Variablen intIndex
        ' auf die Index-Eigenschaft
        ' des neugeschaffenen Knotens. Diese
        ' Variable wird verwendet,
        ' um dem vorliegenden Knoten unter-
        ' geordnete Knotenobjekte hinzuzufgen.
        intIndex = mNode.Index
        ' Mit Hilfe einer Abfrage wird ein
        ' Recordset mit Titeln des aktuellen
        ' Verlags erstellt (alle Titel mit der
        ' aktuellen PubID). Fr jeden Datensatz
        ' der resultierenden Gruppe wird dem
        ' Hierarchieansicht-Steuerelement ein
        ' Knoten-Objekt hinzugefgt. Die
        ' Eigenschaften des neuen Knoten-Objekts
        ' werden ber die Felder "Titles",
        ' "ISBN" und "Authors" festgelegt.
        Set rsTitles = mDbBiblio.OpenRecordset _
        ("select * from Titles Where PubID = " & rsPublishers!PubID)
        Do Until rsTitles.EOF
            Set mNode = tvwDB.Nodes.Add(intIndex, tvwChild)
            mNode.Text = rsTitles!TITLE ' Text.
            mNode.Key = rsTitles!ISBN   ' Eindeutige ID.
            mNode.Tag = "Authors"       ' Tabellennamen.
            mNode.Image = "kleinesBuch" ' Symbol aus der Symbolliste.
            rsTitles.MoveNext ' Bewegen zum nchsten Datensatz in rsTitles.
        Loop
        rsPublishers.MoveNext ' Bewegen zum nchsten Publishers-Datensatz.
    Loop
    ' Ausblenden der Fortschrittsleiste.
    prgLoad.Visible = False
    ' Festlegen des Statusleistenstils auf "normal".
    sbrDB.Style = sbrNormal
    ' Sortieren der Publishers-Knoten.
    tvwDB.Nodes(1).Sorted = True
    ' ffnen des obersten Knotens.
    tvwDB.Nodes(1).Expanded = True
    
    ' Konfigurieren der Statusleiste.
    PublishersStatusBar
End Sub
Private Sub PublishersStatusBar()
    Dim rs As Recordset
    Set rs = mDbBiblio.OpenRecordset("Publishers", dbOpenTable)
    sbrDB.Panels(1).Text = "Name: " & rs.Name
    sbrDB.Panels(2).Text = "Erstellt am:   " & _
    CStr(rs.DateCreated)
    sbrDB.Panels(3).Text = "Zuletzt gendert am:   " & _
    rs.LastUpdated
    sbrDB.Panels(4).Text = "Sperre:   " & rs.LockEdits
End Sub
Private Sub Combo1_Click()
    lvwDB.View = Combo1.ListIndex
End Sub
Private Sub Form_Load()
    ' Konfigurieren des Kombinationsfeld-
    ' Steuerelements Combo1.
    With Combo1
        .AddItem "Groe Symbole"     '0
        .AddItem "Kleine Symbole"    '1
        .AddItem "Liste"             '2
        .AddItem "Details"           '3
        .ListIndex = 3
    End With

    ' Konfigurieren des Listenanzeige-
    ' Steuerelements.
    lvwDB.View = lvwReport
        
    ' Konfigurieren der Fortschrittsleiste.
    prgLoad.Max = 100
    
    ' Konfigurieren des Statusleisten-
    ' Steuerelements. Hinzufgen von
    ' drei Grundflchen und Festlegen von
    ' Autosize fr jede Grundflche.
    sbrDB.Panels.Add
    sbrDB.Panels.Add
    sbrDB.Panels.Add
    
    sbrDB.Panels(1).AutoSize = sbrContents
    sbrDB.Panels(2).AutoSize = sbrSpring
    sbrDB.Panels(3).AutoSize = sbrSpring
    sbrDB.Panels(4).AutoSize = sbrContents
    
    
    ' Konfigurieren von cmdDialog, falls
    ' Biblio.mdb nicht gefunden wird.
    With dlgDialog
        .DialogTitle = "Biblio.mdb wurde nicht gefunden."
        .Filter = "(*.MDB)|*.mdb"
    End With
    
    On Error GoTo errFind
    ' ffnen von Biblio.MDB und Festlegen
    ' der Objektvariablen auf die Datenbank.
    Set mDbBiblio = DBEngine.OpenDatabase("BIBLIO.MDB")
    
    ' Konfigurieren der Hierarchieansicht
    tvwDB.Sorted = True
    Set mNode = tvwDB.Nodes.Add()
    mNode.Text = "Verlage"
    mNode.Tag = mDbBiblio.Name
    mNode.Image = "geschlossen"
    tvwDB.LabelEdit = False
   
    ' Falls Datenbank nicht gefunden wird,
    ' Standardialog-Steuerelement fr die
    ' Suche durch den Benutzer ffnen.
errFind:
    If Err = 3024 Then
        dlgDialog.ShowOpen
        Set mDbBiblio = DBEngine.Workspaces(0).OpenDatabase(dlgDialog.FileName)
        Resume Next
    ElseIf Err <> 0 Then ' Anderer Fehler
        MsgBox "Unerwarteter Fehler: " & Err.Description
        End
    ElseIf Err = 0 Then
        Exit Sub ' Weitermachen
    End If
End Sub


Private Sub lvwDB_ColumnClick(ByVal ColumnHeader As ColumnHeader)
    lvwDB.SortKey = ColumnHeader.Index - 1
    ' Sorted auf True setzen, um Liste
    ' zu sortieren.
    lvwDB.Sorted = True

End Sub

Private Sub lvwDB_ItemClick(ByVal Item As ListItem)
    GetData (Item.Key)
    
End Sub
Private Sub GetData(ISBN)
    If EventFlag <> TITLE Then
        sbrDB.Panels.Clear
        Dim pnlX As Panel
        Set pnlX = sbrDB.Panels.Add(, "ISBN")
        pnlX.AutoSize = sbrSpring
       Set pnlX = sbrDB.Panels.Add(, "Autor")
        pnlX.AutoSize = sbrSpring
        Set pnlX = sbrDB.Panels.Add(, "Ersch.jahr")
        pnlX.Width = 1000
        Set pnlX = sbrDB.Panels.Add(, "Beschreibung")
        pnlX.AutoSize = sbrSpring
    End If
    Dim rsTitles As Recordset
    ' Festlegen der Objektvariablen auf
    ' Recordset "Titles".
    Set rsTitles = mDbBiblio.OpenRecordset("Titles", dbOpenDynaset)
    
    ' Auffinden der ISBN-Nummer in der
    ' Tabelle "Titles" und Statusleisten-
    ' flchen mit Informationen belegen.
    Dim strQuery As String
    strQuery = "ISBN = " & "'" & ISBN & "'"
    rsTitles.FindFirst strQuery
    sbrDB.Panels("Autor").Text = GetAuthor(ISBN)
    sbrDB.Panels("ISBN").Text = rsTitles!ISBN
    If Not IsNull(rsTitles![Year Published]) Then
        sbrDB.Panels("Ersch.jahr").Text = rsTitles![Year Published]
    Else
        sbrDB.Panels("Ersch.jahr").Text = "n/a"
    End If
    If Not IsNull(rsTitles!Description) Then
        sbrDB.Panels("Beschreibung").Text = rsTitles!Description
    Else
        sbrDB.Panels("Beschreibung").Text = "n/a"
    End If
        
    
    ' Festlegen von EventFlag, damit
    ' Grundflchen nicht neu erstellt
    ' werden mssen.
    EventFlag = TITLE
End Sub

Private Sub mnuExit_Click()
    End
End Sub

Private Sub mnuLoad_Click()
    Static Loaded As Boolean
    
    If Loaded = True Then
        Exit Sub
    Else
        cmdLoad_Click
        Loaded = Abs(Loaded - 1)
        mnuLoad.Enabled = False
        
    End If
End Sub

Private Sub tvwDB_Collapse(ByVal Node As Node)
    If Node.Tag = "Verlag" Or Node.Index = 1 _
    Then Node.Image = "geschlossen"
End Sub

Private Sub tvwDB_Expand(ByVal Node As Node)
    If Node.Tag = "Verlag" Or Node.Index = 1 Then
        Node.Image = "geffnet"
        Node.Sorted = True
    End If
   
End Sub

Private Sub MakeColumns()
    ' Lschen der Auflistung der
    ' Spaltenberschriften.
    lvwDB.ColumnHeaders.Clear
    ' Hinzufgen von vier Spalten-
    ' berschriften.
    lvwDB.ColumnHeaders.Add , , "Titel", 2000
    lvwDB.ColumnHeaders.Add , , "Autor"
    lvwDB.ColumnHeaders.Add , , "Ersch.jahr", 350
    lvwDB.ColumnHeaders.Add , , "ISBN"
    
    ' Festlegen der Variablen EventFlag,
    ' damit dies nicht immer wieder
    ' getan wird.
    EventFlag = PUBLISHER
End Sub

Private Sub GetTitles(PubID)
    ' Anzeigen der Fortschrittsleiste.
    prgLoad.Visible = True
    ' Lschen der alten Titel.
    lvwDB.ListItems.Clear
    ' Deklarieren einer Variablen vom
    ' Typ Recordset.
    Dim rsTitles As Recordset
    ' Mit Hilfe einer Abfrage wird ein
    ' Recordset mit Titeln des aktuellen
    ' Verlags erstellt (alle Titel mit
    ' der aktuellen PubID). Fr jeden
    ' Datensatz der resultierenden Gruppe
    ' wird dem Listenanzeige-Steuerelement
    ' ein Listenelement-Objekt hinzugefgt,
    ' und die Eigenschaften des neuen Objekts
    ' ber die Datensatzfelder "Title",
    ' "ISBN" und "Author" festgelegt.
    Set rsTitles = mDbBiblio.OpenRecordset _
    ("select * from Titles where PubID = " & PubID)

    Do Until rsTitles.EOF
            prgLoad.Value = rsTitles.PercentPosition
            Set mItem = lvwDB.ListItems.Add _
            (, CStr(rsTitles!ISBN), rsTitles!TITLE, "Buch", "kleinesBuch")
            
            ' Verwenden einer Funktion, um den
            ' Autor zu erhalten und die
            ' SubItems(1)-Eigenschaft festzulegen.
            mItem.SubItems(1) = GetAuthor(rsTitles!ISBN)
            If Not IsNull(rsTitles![Year Published]) Then
                mItem.SubItems(2) = rsTitles![Year Published]
            End If
            mItem.SubItems(3) = rsTitles!ISBN
            rsTitles.MoveNext
    Loop
    prgLoad.Visible = False
    mCurrentIndex = PubID
End Sub

Private Function GetAuthor(ISBN)
    ' Gibt den Namen eines Autors aus der
    ' Tabelle "Titles" zurck. ffnen zweier
    ' Recordsets. Durchsuchen von "Title Author"
    ' nach der ISBN. Dann wird das Feld Au_ID
    ' verwendet, um nach dem selben Wert in der
    ' Tabelle "Authors" zu suchen.
    ' Zurckgeben des Autorennamens.
    Dim rsTitlesAuthor As Recordset
    Dim rsAuthors As Recordset
    
    Set rsTitlesAuthor = mDbBiblio.OpenRecordset("Title Author", dbOpenDynaset)
    Set rsAuthors = mDbBiblio.OpenRecordset("Authors", dbOpenDynaset)
    
    Dim strQuery As String
    strQuery = "ISBN = " & "'" & ISBN & "'"
    rsTitlesAuthor.FindFirst strQuery
    If rsTitlesAuthor.NoMatch Then
        GetAuthor = "n. v."
        Exit Function
    Else
        strQuery = "Au_ID = " & rsTitlesAuthor!AU_ID
        rsAuthors.FindFirst strQuery
    End If
    GetAuthor = rsAuthors!Author
End Function

Private Sub tvwDB_NodeClick(ByVal Node As Node)
    ' berprfen von Tag nach "Verlag" und
    ' der Variablen EventFlag, um festzustellen,
    ' ob die Spaltenberschriften schon erstellt
    ' wurden. Falls nicht, wird die Prozedur
    ' MakeColumns aufgerufen.
    If Node.Tag = "Verlag" And EventFlag <> _
    PUBLISHER Then MakeColumns
    ' Falls Tag gleich "Verlag" ist und der
    ' Index mItemCurrentIndex nicht der gleiche
    ' wie Node.key ist, dann wird die Prozedur
    ' GetTitles aufgerufen.
    If Node.Tag = "Verlag" And mCurrentIndex <> Val(Node.Key) _
    Then GetTitles Val(Node.Key)
    If Node.Tag = "Verlag" Then
        sbrDB.Panels(1).Text = Node.Text
        sbrDB.Panels(2).Text = Node.Children & " Titel"
        Node.Sorted = True
    End If

Label1.Caption = Node.Tag

End Sub
