Attribute VB_Name = "ModSysMenu"
Option Explicit

'** Men-Funktionen
Declare Function GetSystemMenu Lib "user32" ( _
ByVal hWnd As Long, _
ByVal bRevert As Long) _
As Long

Declare Function AppendMenu Lib "user32" Alias "AppendMenuA" ( _
ByVal hMenu As Long, _
ByVal wFlags As Long, _
ByVal wIDNewItem As Long, _
ByVal lpNewItem As Any) _
As Long

Declare Function InsertMenu Lib "user32" Alias "InsertMenuA" ( _
ByVal hMenu As Long, _
ByVal nPosition As Long, _
ByVal wFlags As Long, _
ByVal wIDNewItem As Long, _
ByVal lpNewItem As Any) _
As Long

Const MF_BYPOSITION = &H400&
Const MF_STRING = &H0&
Const MF_SEPARATOR = &H800&
Const WM_SYSCOMMAND = &H112

'** MessageHook-Funktionen
Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" ( _
ByVal lpPrevWndFunc As Long, _
ByVal hWnd As Long, _
ByVal Msg As Long, _
ByVal wParam As Long, _
ByVal lParam As Long) _
As Long

Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" ( _
ByVal hWnd As Long, _
ByVal nIndex As Long, _
ByVal dwNewLong As Long) _
As Long

Const GWL_WNDPROC = -4

'** Modulvariablen
Dim OldWndProc As Long
Dim SysMenuOwner As Form

Public Sub HookForm(FormToHook As Form)

'** angegebene Form einklinken!

'** wenn schon eingeklinkt: erst ausklinken
If OldWndProc Then UnhookForm
    
'** betroffene Form in SysMenuOwner setzen
Set SysMenuOwner = FormToHook
    
'** Zeiger auf newWndProc einsetzen
OldWndProc = SetWindowLong(SysMenuOwner.hWnd, GWL_WNDPROC, AddressOf newWndProc)

End Sub

Public Sub UnhookForm()

'** Ausklinken!
    
'** wenn nicht eingeklinkt: Abbruch!
If OldWndProc = 0 Then Exit Sub
    
'** alten Zeiger wieder einsetzen
SetWindowLong SysMenuOwner.hWnd, GWL_WNDPROC, OldWndProc
    
'** Variablen lschen
OldWndProc = 0
Set SysMenuOwner = Nothing

End Sub

Function newWndProc(ByVal hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

'** Callback-Funktion: Message abfangen
  
If uMsg = WM_SYSCOMMAND Then '** Systemmen angeklickt!
    If (wParam And &HF000) = 0 Then
    
        '** wenn kein Windows-Standardeintrag:
        On Error Resume Next  '** (falls Aufruf schiefgeht...)
        '** Callback aufrufen!
        SysMenuOwner.SysMenuClicked wParam
    End If
End If
    
'** Message weitergeben an alte Funktion
newWndProc = CallWindowProc(OldWndProc, hWnd, uMsg, wParam, lParam)

End Function


Sub AddItemToSysMenu(TheForm As Form, Optional MenuCaption As String, Optional MenuID As Long, Optional Position As Long = -1)

'**  Eintrag an Systemmen anhngen
'**  TheForm       = Fenster, dessen Systemmen verndert wird
'**  MenuCaption   = Caption ("" oder "-": Separator)
'**  MenuCaptionID = Kennung fr Auswertung
'**  Position      = Position im Systemmen (wenn fehlt: Anhngen)
 
Dim Flags As Long

If MenuCaption = "-" Or MenuCaption = "" Then
    Flags = MF_SEPARATOR
Else
    Flags = MF_STRING
End If
    
'** Systemmen-Handle ermitteln
Dim hMenu As Long
hMenu = GetSystemMenu(TheForm.hWnd, False)
 
'** Meneintrag einfgen
InsertMenu hMenu, Position, Flags Or MF_BYPOSITION, MenuID, MenuCaption

End Sub

Sub ResetSysMenu(TheForm As Form)

'** Original-Systemmen wiederherstellen
GetSystemMenu TheForm.hWnd, True

End Sub
