Attribute VB_Name = "MMSendKeys"
'MMSendKeys
'(w) Jul-Oct/98 by Marcus Warm (mwarm@geosoft.de)
'and Michael Conrad (michaconrad@okay.net)

'Anregung von Heiko Denny
'Literatur: der "Appleman", MSDN Library CD

'V1.0 "MWSendKeys": alternative SendKeys
'Implementation, die nicht mit NumLock rumspielt.
'V1.1 "MWSendKeys": mit Wiederholungen und
'Zusammenfassungen
'V1.2 "MMSendKeys": mit Delay, Wiederholung
'verbessert

Option Explicit
Option Compare Binary

Private Declare Sub keybd_event Lib "user32" (ByVal bVk As Byte, ByVal bScan As Byte, ByVal dwFlags As Long, ByVal dwExtraInfo As Long)
Private Declare Function VkKeyScan Lib "user32" Alias "VkKeyScanA" (ByVal cChar As Byte) As Integer
Private Declare Function CharToOem Lib "user32" Alias "CharToOemA" (ByVal lpszSrc As String, ByVal lpszDst As String) As Long
Private Declare Function OemKeyScan Lib "user32" (ByVal wOemChar As Long) As Long
Private Declare Function timeSetEvent Lib "winmm.dll" (ByVal uDelay As Long, ByVal uResolution As Long, ByVal lpFunction As Long, ByVal dwUser As Long, ByVal uFlags As Long) As Long
Private Declare Function timeKillEvent Lib "winmm.dll" (ByVal uID As Long) As Long

Private Const VK_BACK = &H8
Private Const VK_CONTROL = &H11 'Strg/Ctrl
Private Const VK_DELETE = &H2E
Private Const VK_DOWN = &H28
Private Const VK_END = &H23
Private Const VK_ESCAPE = &H1B
Private Const VK_F1 = &H70
Private Const VK_F2 = &H71
Private Const VK_F3 = &H72
Private Const VK_F4 = &H73
Private Const VK_F5 = &H74
Private Const VK_F6 = &H75
Private Const VK_F7 = &H76
Private Const VK_F8 = &H77
Private Const VK_F9 = &H78
Private Const VK_F10 = &H79
Private Const VK_F11 = &H7A
Private Const VK_F12 = &H7B
Private Const VK_HOME = &H24
Private Const VK_INSERT = &H2D
Private Const VK_LEFT = &H25
Private Const VK_MENU = &H12 'Alt
Private Const VK_NEXT = &H22
Private Const VK_PRIOR = &H21
Private Const VK_RETURN = &HD
Private Const VK_RIGHT = &H27
Private Const VK_RMENU = &HA5 'AltGr
Private Const VK_SHIFT = &H10 'Umschalt
Private Const VK_TAB = &H9
Private Const VK_UP = &H26

Private KeysToSend As String
Private Id&

'Aufrufen um MMSendKeys Aktion (Delay>0)
'abzubrechen
Public Sub MMSendKeysAbort()

  'so wird nichts mehr gesendet
  KeysToSend = ""
  'und der Timer deaktiviert
  timeKillEvent Id
  
End Sub

Private Sub MWClearExt(ext%)
  
  If (ext And &H1) = &H1 Then
    keybd_event VK_SHIFT, 0, 2, 0 'KEY UP
    ext = (ext And Not &H1)
  End If
  If (ext And &H2) = &H2 Then
    keybd_event VK_CONTROL, 0, 2, 0 'KEY UP
    ext = (ext And Not &H2)
  End If
  If (ext And &H4) = &H4 Then
    keybd_event VK_MENU, 0, 2, 0 'KEY UP
    ext = (ext And Not &H4)
  End If

End Sub

'Senden eines einzelnen Zeichens
Public Sub MWSendChar(Ascii As Integer)
  Dim oemchar$, scan%, vk%, vko%, h%
  Dim Shift As Boolean, AltGr As Boolean
  Const k = VK_RMENU 'klappt nicht,
  'z.B. AltGr+Q = @

  vko = VkKeyScan(Ascii)
  vk = (vko And &HFF)
  oemchar = "  "
  CharToOem Chr(Ascii), oemchar
  scan = OemKeyScan(Asc(oemchar)) And &HFF
  
  'wird Umschalt/AltGr bentigt?
  Shift = ((vko And &H100) = &H100)
  AltGr = ((vko And &H600) = &H600)
  If Shift Then
    keybd_event VK_SHIFT, 0, 0, 0 'KEY PRESS
  End If
'  If AltGr Then
'    keybd_event k, 0, 0, 0 'KEY PRESS
'  End If
  
  keybd_event vk, scan, 0, 0 'KEY PRESS
  keybd_event vk, scan, 2, 0 'KEY UP
  
  If Shift Then
    keybd_event VK_SHIFT, 0, 2, 0 'KEY UP
  End If
'  If AltGr Then
'    keybd_event k, 0, 2, 0 'KEY UP
'  End If
  
End Sub

'alternative Routine zu VB5 SendKeys
Public Sub MWSendKeys(Text As String)
  Dim t%, l%, c$, o%, o2%, i%, n%
  Dim clearExt As Boolean, ext%
  
  l = Len(Text): t = 1
  Do While t <= l
    clearExt = False
    c = Mid(Text, t, 1)
    Select Case c
      Case "{" 'Befehlsfolge
        o = InStr(t + 1, Text, "}")
        If o = 0 Then Exit Sub
        c = Mid(Text, t + 1, o - t - 1)
        n = 1
        'Wiederholungen
        o2 = InStr(1, c, " ", vbBinaryCompare)
        If o2 > 0 Then
          n = Val(Mid(c, o2 + 1))
          c = Left(c, o2 - 1)
        End If
        For i = 1 To n
          Select Case UCase(c)
            Case "+", "^", "%", "{", "}", "~", "(", ")"
              MWSendChar Asc(c)
            Case "BACKSPACE", "BS", "BKSP": MWSpecial VK_BACK
            Case "DELETE", "DEL": MWSpecial VK_DELETE
            Case "DOWN":  MWSpecial VK_DOWN
            Case "END":   MWSpecial VK_END
            Case "ENTER": MWSpecial VK_RETURN
            Case "ESC":   MWSpecial VK_ESCAPE
            Case "HOME":  MWSpecial VK_HOME
            Case "INSERT", "INS": MWSpecial VK_INSERT
            Case "LEFT":  MWSpecial VK_LEFT
            Case "PGDN":  MWSpecial VK_NEXT
            Case "PGUP":  MWSpecial VK_PRIOR
            Case "RIGHT": MWSpecial VK_RIGHT
            Case "TAB":   MWSpecial VK_TAB
            Case "UP":    MWSpecial VK_UP
            Case "F1":    MWSpecial VK_F1
            Case "F2":    MWSpecial VK_F2
            Case "F3":    MWSpecial VK_F3
            Case "F4":    MWSpecial VK_F4
            Case "F5":    MWSpecial VK_F5
            Case "F6":    MWSpecial VK_F6
            Case "F7":    MWSpecial VK_F7
            Case "F8":    MWSpecial VK_F8
            Case "F9":    MWSpecial VK_F9
            Case "F10":   MWSpecial VK_F10
            Case "F11":   MWSpecial VK_F11
            Case "F12":   MWSpecial VK_F12
            'nicht untersttzt: BREAK,
            'CAPSLOCK, HELP, NUMLOCK,
            'PRTSC, F13-F16
            Case Else 'einzelnes Zeichen
              MWSendChar Asc(c)
          End Select
        Next i
        t = o + 1
      
      Case "+" 'Umschalt/Shift
        keybd_event VK_SHIFT, 0, 0, 0 'KEY PRESS
        ext = &H1 'set flag
        t = t + 1
      
      Case "^" 'Strg/Ctrl
        keybd_event VK_CONTROL, 0, 0, 0 'KEY PRESS
        ext = &H2
        t = t + 1
      
      Case "%" 'Alt
        keybd_event VK_MENU, 0, 0, 0 'KEY PRESS
        ext = &H4
        t = t + 1
      
      Case "~" 'ENTER
        MWSpecial VK_RETURN
        t = t + 1
      
      Case "(" 'Zusammenfassung
        o = InStr(t + 1, Text, ")")
        If o = 0 Then Exit Sub
        c = Mid(Text, t + 1, o - t - 1)
        For i = 1 To Len(c)
          MWSendChar Asc(Mid(c, i, 1))
        Next i
        t = o + 1
        clearExt = True
      
      Case Else 'einzelnes Zeichen
        MWSendChar Asc(c)
        t = t + 1
        clearExt = True
        
    End Select
    
    If ext And clearExt Then
      MWClearExt ext
    End If
  Loop

  If ext Then MWClearExt ext

End Sub

Private Sub MWSpecial(vk%)
  
  keybd_event vk, 0, 0, 0 'KEY PRESS
  keybd_event vk, 0, 2, 0 'KEY UP

End Sub

'SendKeys Prozedur mit optionaler Angabe
'einer Verzgerung in Millisekunden
Public Sub MMSendKeys(Text As String, Optional Delay As Integer = 0)
  
  If Delay > 0 Then
    'zu sendende Zeichenfolge
    KeysToSend = Text
    'Timer einrichten, der dann
    'MMSendKeysTimeProc aufruft, welche
    'dann MWSendKeys aufruft
    Id = timeSetEvent(Delay, 0, _
      AddressOf MMSendKeysTimeProc, 0, 0)
  Else
    MWSendKeys Text
  End If
  
End Sub

'Callback-Prozedur wird ausgefhrt,
'wenn MMSendKeys aufgerufen wird
Public Sub MMSendKeysTimeProc(ByVal TimerID%, ByVal msg%, ByVal dwUser&, ByVal dw1&, ByVal dw2&)
  
'allgemeine Deklaration von TimeProc aus MSDN:
'  void CALLBACK TimeProc(UINT uID,
'  UINT uMsg,DWORD dwUser,DWORD dw1,DWORD dw2)
  
  On Error Resume Next
  MWSendKeys KeysToSend
  
End Sub

