Option Explicit

Type FontInfo

    FontName As String
    FontSize As Single
    FontBold As Integer
    FontItalic As Integer
    FontUnderline As Integer

End Type

Global FI As FontInfo

Dim CRLF As String

Function FindCRLF (txt As String) As Integer
    'if there is no CRLF, FindCRLF will be zero (FALSE)
    FindCRLF = InStr(txt, CRLF)
End Function

Sub PrintOnPage (txtData As String)
    Dim TempStr As String           ' Line in progress
    Dim HighStr As String           ' Used for Page Height
    Dim CurrentPoint As Long        ' Pointer into txtData
    Dim LenOfText As Long           ' Length of txtData
    Dim Done As Integer             ' (Boolean) controls End of process
    Dim TW As Single                ' Text Width
    Dim TH As Single                ' Text Height

    CRLF = Chr$(13) & Chr$(10)

    LenOfText = Len(txtData)
    If LenOfText = 0 Then Exit Sub  ' Nothing to print
    
    If FindCRLF(txtData) Then        ' Make sure there is at least one CRLF
    Else                            ' in the text
        txtData = txtData & CRLF
    End If
    
    CurrentPoint = 1                ' point to beginning of txtData
    
    Printer.FontName = FI.FontName  ' set Font "stuff" for printer
    Printer.FontSize = FI.FontSize
    Printer.FontBold = FI.FontBold
    Printer.FontItalic = FI.FontItalic
    Printer.FontUnderline = FI.FontUnderline

    Printer.ScaleMode = 5           ' set scale mode to inches
    Printer.CurrentY = 1            ' set top margin of 1"

    ' this is the main loop -- we'll loop through here until done

    Do Until Done
        
        TempStr = Mid$(txtData, CurrentPoint, 2)     ' set work area to first 2 characters
        CurrentPoint = CurrentPoint + 2             ' bump current pointer
        TW = 0                                      ' set width of text to zero

        ' loop through here until:
        '   - width of text is 6 1/2"
        '   - we find a CRLF
        '   - we reach the end of txtData

        Do Until TW > 6.5 Or FindCRLF(TempStr) Or CurrentPoint > LenOfText
            TempStr = TempStr & Mid$(txtData, CurrentPoint, 1)   ' add one more character to TempStr
            TW = Printer.TextWidth(TempStr)                     ' Now how wide is it?
            
            If TW > 6.5 Then
                ' we've got 6 1/2" (max width of printable area)
                '   we need to back up to get last space
                '   & not split in mid word
                If InStr(TempStr, " ") Then
                    ' there is a space in current line
                    If Mid$(txtData, CurrentPoint + 1, 1) = " " Then
                    Else
                        ' bump backwards till we find space
                        Do Until Mid$(txtData, CurrentPoint, 1) = " "
                            CurrentPoint = CurrentPoint - 1
                            TempStr = Left$(TempStr, Len(TempStr) - 1)
                        Loop
                    End If
                End If
                TempStr = TempStr & CRLF    ' add CRLF to end of line
            End If
            CurrentPoint = CurrentPoint + 1 ' bump current pointer
        Loop
    
        Printer.CurrentX = .75      ' set margin (you get .25" without doing anything) + .25 = 1" margin
        Printer.Print TempStr,      ' print TempStr
        
        ' add line just printed to HighStr
        HighStr = HighStr & TempStr
        TH = Printer.TextHeight(HighStr)  ' determine Text Height

        If TH > 9 Then
            ' we've run out of room on the page 9" is max pintable area
            Printer.NewPage
            Printer.CurrentY = 1        ' set top margin
            HighStr = ""
        End If
        
        If CurrentPoint >= LenOfText Then
            Done = True
        End If
    Loop

    Printer.EndDoc

End Sub

