Attribute VB_Name = "NoDocWatson"
Option Explicit

'######################################################################
'# Quelle des Moduls: http://www.basicworld.com/BPOnline/bo020699.htm #
'# Ein Service von BasicPro -  1998, 1999 by Steingrber Fachverlag  #
'######################################################################
'
'Winfried Kaiser
'Nie mehr Dr. Watson!
'--------------------
'
'Eines der grten Probleme im Leben eines VB-Entwicklers ist, da sein Programm auf
'vereinzelten(!) Systemen nicht luft (z.B. "Access Violation in KERNEL32.DLL" und
'hnlich schne Dinge) und dort zu einem Programmabbruch durch WINDOWS fhrt, weil
'VB diese Exceptions leider nicht behandelt. Der Programmabbruch wird zwar getreulich
'von Dr. Watson aufgezeichnet, aber welcher VB-Entwickler kann mit dieser Information
'schon etwas anfangen?
'
'Im "Visual Basic Programmers Journal" vom Mai '99 wurde nun von Jonathan Lunman ein
'Artikel verffentlicht (S. 108ff), der dieses groes Praxisproblem lsen hilft und
'sicher von allgemeinem Interesse ist. In diesem Artikel wird beschrieben, wie man
'die Windows-Exceptions, die nicht von VB abgefangen werden (Page faults, Illegal
'Instructions usw.) im eigenen Anwenderprogramm abfangen und behandeln kann, und so
'dem Anwender die bliche schreckliche Crash-Meldung erspart und Dr. Watson die Arbeit
'abnimmt.
'
'Dies wird erreicht, indem man mit der SetUnhandledExceptionFilter-API und AddressOf
'(einsetzbar daher erst ab VB5) auf einen Exception-Handler im eigenen VB-Programm
'verweist, der dann beim Auftreten eines dieser Fehler aktiviert wird. Der geniale
'Trick ist dann, in diesem Handler mit Err.Raise den VB-Error-Handler anzuwerfen, so
'da man dann die VB-bliche Fehlerbehandlungs-Mglichkeiten hat.
'
'Wenn man das Programm (z.B. mit NuMega FailSafe) fr eine umfangreiche Fehlerbehandlung
'ausrsten lt, kann man dann sogar genau (bis auf Zeilenebene!) lokalisieren, wo im
'VB-Programm dieser Crash verursacht wurde, so da man einen sehr guten Anhaltspunkt
'fr die Fehlersuche bekommt - einer der besten Praxis-Tips seit langem!
'
'------------------------------------------------------------------
'
' Zum Einsatz des Moduls starten Sie die berwachung wie folgt:
'
'  Result = SetUnhandledExceptionFilter(AddressOf MyExceptionFilter)
'
' Vergessen Sie nicht, diese Zuweisung bei Nutzungsende (z.B. Ende
' Ihrer Anwendung) wieder rckgngig zu machen:
'
'  Result = SetUnhandledExceptionFilter(0&)
'
' Am Ende des Moduls finden Sie eine Testroutine (ExceptionTest),
' die eine entsprechende Schutzverletzung simuliert.
'
'                           VIEL ERFOLG!
'
'------------------------------------------------------------------

  


  'This API function installs your custom exception handler.
 
 Public Declare Function SetUnhandledExceptionFilter Lib "kernel32" _
    (ByVal lpTopLevelExceptionFilter As Long) As Long
  
  'This API function is used to raise exceptions.
  Private Declare Sub RaiseException Lib "kernel32" _
    (ByVal dwExceptionCode As Long, ByVal dwExceptionFlags As Long, _
    ByVal nNumberOfArguments As Long, lpArguments As Long)
  
  'Possible return values for the Unhandled Exception Filter.
  Private Const EXCEPTION_CONTINUE_EXECUTION = -1
  Private Const EXCEPTION_CONTINUE_SEARCH = 0
  Private Const EXCEPTION_EXECUTE_HANDLER = 1
  
  'Maximum number of parameters an Exception_Record can have
  Private Const EXCEPTION_MAXIMUM_PARAMETERS = 15
  
  'Structure that contains processor-specific register data
  Private Type CONTEXT
    FltF0 As Double
    FltF1 As Double
    FltF2 As Double
    FltF3 As Double
    FltF4 As Double
    FltF5 As Double
    FltF6 As Double
    FltF7 As Double
    FltF8 As Double
    FltF9 As Double
    FltF10 As Double
    FltF11 As Double
    FltF12 As Double
    FltF13 As Double
    FltF14 As Double
    FltF15 As Double
    FltF16 As Double
    FltF17 As Double
    FltF18 As Double
    FltF19 As Double
    FltF20 As Double
    FltF21 As Double
    FltF22 As Double
    FltF23 As Double
    FltF24 As Double
    FltF25 As Double
    FltF26 As Double
    FltF27 As Double
    FltF28 As Double
    FltF29 As Double
    FltF30 As Double
    FltF31 As Double
  
    IntV0 As Double
    IntT0 As Double
    IntT1 As Double
    IntT2 As Double
    IntT3 As Double
    IntT4 As Double
    IntT5 As Double
    IntT6 As Double
    IntT7 As Double
    IntS0 As Double
    IntS1 As Double
    IntS2 As Double
    IntS3 As Double
    IntS4 As Double
    IntS5 As Double
    IntFp As Double
    IntA0 As Double
    IntA1 As Double
    IntA2 As Double
    IntA3 As Double
    IntA4 As Double
    IntA5 As Double
    IntT8 As Double
    IntT9 As Double
    IntT10 As Double
    IntT11 As Double
    IntRa As Double
    IntT12 As Double
    IntAt As Double
    IntGp As Double
    IntSp As Double
    IntZero As Double
  
    Fpcr As Double
    SoftFpcr As Double
  
    Fir As Double
    Psr As Long
  
    ContextFlags As Long
    Fill(4) As Long
  End Type
  
  'Structure that describes an exception.
  Private Type EXCEPTION_RECORD
      ExceptionCode As Long
      ExceptionFlags As Long
      pExceptionRecord As Long  ' Pointer to an EXCEPTION_RECORD structure
      ExceptionAddress As Long
      NumberParameters As Long
      ExceptionInformation(EXCEPTION_MAXIMUM_PARAMETERS) As Long
  End Type
  
  'Structure that contains exception information that can be used by a debugger.
  Private Type EXCEPTION_DEBUG_INFO
    pExceptionRecord As EXCEPTION_RECORD
    dwFirstChance As Long
  End Type
  
  'The EXCEPTION_POINTERS structure contains an exception record with a
  'machine-independent description of an exception and a context record
  'with a machine-dependent description of the processor context at the
  'time of the exception.
  Private Type EXCEPTION_POINTERS
    pExceptionRecord As EXCEPTION_RECORD
    ContextRecord As CONTEXT
  End Type
  
  'Standard Exception Codes
  Private Const EXCEPTION_ACCESS_VIOLATION = &HC0000005
  Private Const EXCEPTION_DATATYPE_MISALIGNMENT = &H80000002
  Private Const EXCEPTION_BREAKPOINT = &H80000003
  Private Const EXCEPTION_SINGLE_STEP = &H80000004
  Private Const EXCEPTION_ARRAY_BOUNDS_EXCEEDED = &HC000008C
  Private Const EXCEPTION_FLT_DENORMAL_OPERAND = &HC000008D
  Private Const EXCEPTION_FLT_DIVIDE_BY_ZERO = &HC000008E
  Private Const EXCEPTION_FLT_INEXACT_RESULT = &HC000008F
  Private Const EXCEPTION_FLT_INVALID_OPERATION = &HC0000090
  Private Const EXCEPTION_FLT_OVERFLOW = &HC0000091
  Private Const EXCEPTION_FLT_STACK_CHECK = &HC0000092
  Private Const EXCEPTION_FLT_UNDERFLOW = &HC0000093
  Private Const EXCEPTION_INT_DIVIDE_BY_ZERO = &HC0000094
  Private Const EXCEPTION_INT_OVERFLOW = &HC0000095
  Private Const EXCEPTION_PRIVILEGED_INSTRUCTION = &HC0000096
  Private Const EXCEPTION_IN_PAGE_ERROR = &HC0000006
  Private Const EXCEPTION_ILLEGAL_INSTRUCTION = &HC000001D
  Private Const EXCEPTION_NONCONTINUABLE_EXCEPTION = &HC0000025
  Private Const EXCEPTION_STACK_OVERFLOW = &HC00000FD
  Private Const EXCEPTION_INVALID_DISPOSITION = &HC0000026
  Private Const EXCEPTION_GUARD_PAGE_VIOLATION = &H80000001
  Private Const EXCEPTION_INVALID_HANDLE = &HC0000008
  Private Const EXCEPTION_CONTROL_C_EXIT = &HC000013A
  
  'This is a friendly declaration of the CopyMemory function.  It is used to copy
  'data into an EXTENSION_RECORD structure from a pointer to another structure.

  Private Declare Sub CopyExceptionRecord Lib "kernel32" Alias "RtlMoveMemory" _
    (pDest As EXCEPTION_RECORD, ByVal LPEXCEPTION_RECORD As Long, ByVal lngBytes As Long)

'
'******************************
'  MyExceptionFilter
'******************************
'  This function will be called when an unhandled exception occurs.
'  It raises an error so that it can be trapped with an ON ERROR statement
'  in the procedure that caused the exception.
Public Function MyExceptionFilter(ByRef ExceptionPtrs As EXCEPTION_POINTERS) As Long
  Dim Rec As EXCEPTION_RECORD
  Dim strException As String
  Dim SubErrorCode As Long
  Dim Message As String
  
  '
  '  Gendert von W. Kaiser, Fortune Systems GmbH & Co.
  '
  Static TerminationInProgess As Boolean, LastExceptionCode As Long
  
  If TerminationInProgess Then
    '
    '  Gendert von W. Kaiser, Fortune Systems GmbH & Co.
    '
    'Unsere eigene Programm-Clean-Up-Routine verursachte wieder eine Exception!
    'Damit haben wir keine Chance mehr fr einen kontrollierten Abbruch.
    '
    'Wir lassen daher jetzt Windows und Dr. Watson ihren lichen Job tun!
    '
    MsgBox "Leider kein Glck gehabt!", vbCritical + vbOKOnly
    'Unser "Exception Filter" wird beendet
    SubErrorCode = SetUnhandledExceptionFilter(0&)
    'Der Fehler wird noch einmal erzeugt,
    Call RaiseException(LastExceptionCode, 0&, 0&, 0&)
  Else
    'Get current exception record.
    Rec = ExceptionPtrs.pExceptionRecord
    
    'If Rec.pExceptionRecord is not zero, then it is a nested exception and
    'Rec.pExceptionRecord points to another EXCEPTION_RECORD structure.  Follow
    'the pointers back to the original exception.
    With Rec
        Do Until .pExceptionRecord = 0
          CopyExceptionRecord Rec, .pExceptionRecord, Len(Rec)
        Loop
    End With
    
    'Translate the exception code into a user-friendly string.
    strException = GetExceptionText(Rec.ExceptionCode, SubErrorCode)
    '
    '  Gendert von W. Kaiser, Fortune Systems GmbH & Co.
    '
    ' Hiermit wird ein kontrollierter Abbruch ermglicht
    '
    ' Wenn man aber (z.B. mit NuMega FailSafe) die Fehlerursache und -stelle finden will,
    ' mu der folgende 'On Error'-Befehl auskommentiert werden!!!
    '
    On Error GoTo SystemError
    'Raise an error to return control to the calling procedure.
    Err.Raise 10000 + SubErrorCode, "Windows-System-Fehler", strException
  End If
  Exit Function
'
'  Gendert von W. Kaiser, Fortune Systems GmbH & Co.
'
SystemError:
  '
  ' 'Wir versuchen, das Programm "ordentlich" abzuschlieen
  '
  Message = "Windows-System-Fehler aufgetreten!" & vbCrLf & vbCrLf
  Message = Message & "Fehler:" & Str$(10000 + SubErrorCode) & " (" & strException & ")" & vbCrLf & vbCrLf
  Message = Message & "Es wird dennoch versucht, das Programm ordentlich zu beenden," & vbCrLf
  Message = Message & "was aber durchaus fehlschlagen kann! Drcken Sie also die Daumen" & vbCrLf
  Message = Message & "und bettigen Sie die 'OK'-Schaltflche." & vbCrLf
  MsgBox Message, "Windows-System-Fehler", vbOKOnly + vbCritical
  LastExceptionCode = Rec.ExceptionCode
  Call EndeProc                'Wir rufen jetzt unsere eigene Programm-Clean-Up-Routine auf, die das Programm auch beendet.
End Function

'******************************
'  GetExceptionText
'******************************
'  This function receives an exception code value and returns the
'  text description of the exception.
'
Private Function GetExceptionText(ByVal ExceptionCode As Long, SubErrorCode As Long) As String
  Dim strExceptionString As String
  
  Select Case ExceptionCode
    Case EXCEPTION_ACCESS_VIOLATION
      strExceptionString = "Access Violation"
      SubErrorCode = One
    Case EXCEPTION_DATATYPE_MISALIGNMENT
      strExceptionString = "Data Type Misalignment"
      SubErrorCode = Two
    Case EXCEPTION_BREAKPOINT
      strExceptionString = "Breakpoint"
      SubErrorCode = Three
    Case EXCEPTION_SINGLE_STEP
      strExceptionString = "Single Step"
      SubErrorCode = Four
    Case EXCEPTION_ARRAY_BOUNDS_EXCEEDED
      strExceptionString = "Array Bounds Exceeded"
      SubErrorCode = Five
    Case EXCEPTION_FLT_DENORMAL_OPERAND
      strExceptionString = "Float Denormal Operand"
      SubErrorCode = Six
    Case EXCEPTION_FLT_DIVIDE_BY_ZERO
      strExceptionString = "Divide By Zero"
      SubErrorCode = Seven
    Case EXCEPTION_FLT_INEXACT_RESULT
      strExceptionString = "Floating Point Inexact Result"
      SubErrorCode = Eight
    Case EXCEPTION_FLT_INVALID_OPERATION
      strExceptionString = "Invalid Operation"
      SubErrorCode = Nine
    Case EXCEPTION_FLT_OVERFLOW
      strExceptionString = "Float Overflow"
      SubErrorCode = Ten
    Case EXCEPTION_FLT_STACK_CHECK
      strExceptionString = "Float Stack Check"
      SubErrorCode = 11
    Case EXCEPTION_FLT_UNDERFLOW
      strExceptionString = "Float Underflow"
      SubErrorCode = 12
    Case EXCEPTION_INT_DIVIDE_BY_ZERO
      strExceptionString = "Integer Divide By Zero"
      SubErrorCode = 13
    Case EXCEPTION_INT_OVERFLOW
      strExceptionString = "Integer Overflow"
      SubErrorCode = 14
    Case EXCEPTION_PRIVILEGED_INSTRUCTION
      strExceptionString = "Privileged Instruction"
      SubErrorCode = 15
    Case EXCEPTION_IN_PAGE_ERROR
      strExceptionString = "In Page Error"
      SubErrorCode = 16
    Case EXCEPTION_ILLEGAL_INSTRUCTION
      strExceptionString = "Illegal Instruction"
      SubErrorCode = 17
    Case EXCEPTION_NONCONTINUABLE_EXCEPTION
      strExceptionString = "Non Continuable Exception"
      SubErrorCode = 18
    Case EXCEPTION_STACK_OVERFLOW
      strExceptionString = "Stack Overflow"
      SubErrorCode = 19
    Case EXCEPTION_INVALID_DISPOSITION
      strExceptionString = "Invalid Disposition"
      SubErrorCode = 20
    Case EXCEPTION_GUARD_PAGE_VIOLATION
      strExceptionString = "Guard Page Violation"
      SubErrorCode = 21
    Case EXCEPTION_INVALID_HANDLE
      strExceptionString = "Invalid Handle"
      SubErrorCode = 22
    Case EXCEPTION_CONTROL_C_EXIT
      strExceptionString = "Control-C Exit"
      SubErrorCode = 23
    Case Else
      strExceptionString = "Unknown (&H" & Right("00000000" & Hex(ExceptionCode), Eight) & ")"
      SubErrorCode = 24
  End Select
  GetExceptionText = strExceptionString
End Function

Sub ExceptionTest()
  Dim Result As Long
  
  Result = SetUnhandledExceptionFilter(AddressOf MyExceptionFilter)
  On Error GoTo Error_Trap
  
  Call RaiseException(EXCEPTION_ACCESS_VIOLATION, Zero, Zero, Zero)

  Result = SetUnhandledExceptionFilter(0&)
  Exit Sub
  
Error_Trap:
  Resume Next
End Sub

