Attribute VB_Name = "NetAPI"
Option Explicit

Global Const SERVER_TYPE_NT = &H1000
Global Const SERVER_TYPE_NTSERVER = &H8
Global Const SERVER_TYPE_SQLSERVER = &H4
Global Const SERVER_TYPE_ALL = &HFFFF


Type SERVER_INFO_100
    sv100_platform_id As Long
    sv100_servername As Long
End Type
      
Type SERVER_INFO_101
    wki101_platform_id As Long
    wki101_servername As Long
    wki101_langroup As Long
    wki101_ver_major As Long
    wki101_ver_minor As Long
    wki101_lanroot As Long
End Type

Type WKSTA_INFO_100
    wki100_platform_id As Long
    wki100_computername As Long
    wki100_langroup As Long
    wki100_ver_major As Long
    wki100_ver_minor As Long
End Type
                    
Declare Function NetServerEnum Lib "Netapi32" (ByVal sServerName$, ByVal lLevel&, _
                    vBuffer As Any, lPreferedMaxLen&, lEntriesRead&, lTotalEntries&, _
                    ByVal lServerType&, ByVal sDomain$, vResume As Any) As Long
                       
Declare Function NetWkstaGetInfo Lib "Netapi32" (ByVal sServerName$, ByVal lLevel&, _
                    vBuffer As Any) As Long
    
Declare Function NetMessageBufferSend Lib "Netapi32" (ByVal sServerName$, _
                        ByVal sMsgName$, ByVal sFromName$, _
                        ByVal sMessageText$, ByVal lBufferLength&) As Long


Declare Function NetApiBufferFree Lib "Netapi32" (ByVal lBuffer&) As Long

Declare Sub lstrcpyW Lib "Kernel32" (vDest As Any, ByVal vSrc As Any)
Declare Sub lstrcpy Lib "Kernel32" (vDest As Any, ByVal vSrc As Any)
Declare Sub lstrcpynW Lib "Kernel32" (ByVal vDest As Any, ByVal vSrc As Any, lLength As Long)
Declare Sub RtlMoveMemory Lib "Kernel32" (dest As Any, vSrc As Any, ByVal lSize&)

Function GetNetworkSystemNames(lServerType As Long) As Collection
    
    Dim lReturnCode As Long
    Dim bBuffer(512) As Byte
    Dim i As Integer, X As Integer
    Dim tSeverInfo101 As SERVER_INFO_101, lSeverInfo101 As Long
    Dim sComputerName As String
    Dim lPreferedMaxLen As Long
    Dim lEntriesRead As Long
    Dim lTotalEntries As Long
    Dim sDomain As String
    Dim vResume As Variant
    Dim lSeverInfo101StructPtr As Long
    
    Dim serverCollection As New Collection
         
    'Clear all of the sComputerName
    sComputerName = vbNullString
         
    'Call NetServerEnum to get a list of Servers
    lReturnCode = NetServerEnum("", 101, lSeverInfo101, lPreferedMaxLen, lEntriesRead, lTotalEntries, lServerType, sDomain, vResume)
         
    ' NetServerEnum Index is 1 based
    X = 1
    lSeverInfo101StructPtr = lSeverInfo101
                 
    Do While X <= lTotalEntries
                 
        RtlMoveMemory tSeverInfo101, ByVal lSeverInfo101StructPtr, Len(tSeverInfo101)
         
        lstrcpyW bBuffer(0), tSeverInfo101.wki101_servername
        
        'Get every other byte from Unicode string.
        i = 0
        Do While bBuffer(i) <> 0
            sComputerName = sComputerName & Chr(bBuffer(i))
            i = i + 2
        Loop
            
        serverCollection.Add Item:=sComputerName
        'GetServerInfo.Add sComputerName
            
        sComputerName = ""
        X = X + 1
            
        lSeverInfo101StructPtr = lSeverInfo101StructPtr + Len(tSeverInfo101)
         
    Loop
        
    lReturnCode = NetApiBufferFree(lSeverInfo101)

    Set GetNetworkSystemNames = serverCollection
End Function


Public Function GetLocalSystemName()
    Dim lReturnCode As Long
    Dim bBuffer(512) As Byte
    Dim i As Integer
    Dim twkstaInfo100 As WKSTA_INFO_100, lwkstaInfo100 As Long
    Dim lwkstaInfo100StructPtr As Long
    Dim sLocalName As String
    
    lReturnCode = NetWkstaGetInfo("", 100, lwkstaInfo100)
 
    lwkstaInfo100StructPtr = lwkstaInfo100
                 
    If lReturnCode = 0 Then
                 
        RtlMoveMemory twkstaInfo100, ByVal lwkstaInfo100StructPtr, Len(twkstaInfo100)
         
        lstrcpyW bBuffer(0), twkstaInfo100.wki100_computername
        
        'Get every other byte from Unicode string.
        i = 0
        Do While bBuffer(i) <> 0
            sLocalName = sLocalName & Chr(bBuffer(i))
            i = i + 2
        Loop
            
        GetLocalSystemName = sLocalName
         
    End If

End Function

Public Function GetDomainName() As String
    
    Dim lReturnCode As Long
    Dim bBuffer(512) As Byte
    Dim i As Integer
    Dim twkstaInfo100 As WKSTA_INFO_100, lwkstaInfo100 As Long
    Dim lwkstaInfo100StructPtr As Long
    Dim sDomainName As String
    
    lReturnCode = NetWkstaGetInfo("", 100, lwkstaInfo100)
 
    lwkstaInfo100StructPtr = lwkstaInfo100
                 
    If lReturnCode = 0 Then
                 
        RtlMoveMemory twkstaInfo100, ByVal lwkstaInfo100StructPtr, Len(twkstaInfo100)
         
        lstrcpyW bBuffer(0), twkstaInfo100.wki100_langroup
        
        'Get every other byte from Unicode string.
        i = 0
        Do While bBuffer(i) <> 0
            sDomainName = sDomainName & Chr(bBuffer(i))
            i = i + 2
        Loop
            
        GetDomainName = sDomainName
         
    End If
        
End Function
